h53367
s 00056/00000/00000
d D 1.1 84/07/25 13:43:49 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <signal.h>
#include <carl/libsf.h>

/*
 * quitit - trap interrupts, close all open csound files and exit.
 * quitit() is used by all csound system programs, i.e., those that
 * call sopensf() and sclosesf().  
 * User level programs (that call opensf() and closesf()) trap to
 * the routine sfquitit().
 */

/* from sfsetiname.c */
extern char    *sfmyname;
extern char    *sigs[];

extern struct sndesc   *rootsfd;
int     sfintlevel;
extern int      free_list;	/* from allocsf.c */

quitit (ind)
int     ind;			/* the system sets up value of ind */
{
	ignall ();		/* reset to ignore all interrupts */
	sfintlevel++;		/* tell sclosesf() we are already at int.
				   level */
	if (ind != SIGPIPE) {
		if (sfmyname != NULL)
			fprintf (stderr, "\n%s interrupt: %s\n", 
				sfmyname, sigs[ind]);
		else
			fprintf (stderr, "\ncsound interrupt: %s\n", 
				sigs[ind]);
	}

	if (free_list) {	/* error while accessing free list */
		char    buf[128];
		(void) sprintf (buf, 
		    "csound: %s exception while processing free list %s\n", 
		    sigs[ind]);
#ifdef INFINITE
		report (buf);
#endif INFINITE
		notify ("dgl", buf);
		fprintf (stderr, "csound: free list contaminated.\n");
		fprintf (stderr, "\tcall a wizard.\n");
		panic ();
		exit (1);
	}

	if (ind != SIGHUP && ind != SIGINT && ind != SIGKILL &&
			ind != SIGQUIT && ind != SIGTERM && ind != SIGPIPE)
		panic ();
	exit (1);
}
E 1
