h40634
s 00052/00000/00000
d D 1.1 84/07/25 13:43:21 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>


/* 
 * Take ptr to head of circular allocation arena, 
 * another pointer to linked list of disk blocks in sfd, and mark the union
 * of sfd list and arena with a value as follows: if save!=0, then
 * mark all ALLOCATED blocks USED, mark all FREED blocks UNUSED. If
 * save==0, mark all blocks in the union set UNUSED, regardless.  
 */

markall (head, sfd, save)
struct dskblk  *head;
struct sndesc  *sfd;
int     save;
{
	struct dskblk  *p,
	               *h;	/* points to link in arena */
	struct dskblk  *q;	/* points to link on sfd */

	if (sfd->ncyls == 0 && sfd->cp == NULL)
		return (0);	/* nothing to look at */
	for (h = head, q = sfd->cp; q != NULL; q = q->next) {
		if (h->base > q->base)
			h = head;/* start at top again */
		for (p = h; p->flag != EOLIST; p = p->next) {
			if ((p->base == q->base) && (p->len == q->len)) {
			/* we have a match */
				if (save) {
					if (q->flag == ALLOCATED)
						p->flag = q->flag = USED;
					else
						if (q->flag == FREED)
						    p->flag = q->flag = UNUSED;
				}
				else {
					p->flag = q->flag = UNUSED;
				}
				h = p;
				break;
			}
		}
	}
	if (p->flag == EOLIST) {
		fprintf (stderr, "markall: bad or nonexistant dskblk.\n");
		return (-1);
	/* got to end of allocation arena, indicating mismatch. */
	}
	return (0);
}
E 1
