h54175
s 00003/00000/00067
d D 1.2 84/08/06 16:17:35 disk 2 1
c elaborated comment at beginning
e
s 00067/00000/00000
d D 1.1 84/07/25 13:42:59 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <signal.h>

/*
 * There is a critical section of code while a program has the free list
 * opened for update during which all interrupts must be locked out.
 * This happens during portions of sopensf() and sclosesf().
I 2
 * The routine that undoes ignoring interrupts is in catchall().
 * It also has a useful comment.
E 2
 */

extern int      (*intstat) ();

ignall () 
{
	extern int (*signal())();
	int     (*intproc) ();
I 2

E 2
	intstat = signal (SIGINT, SIG_IGN);
	(void) signal (SIGHUP, SIG_IGN);
	(void) signal (SIGQUIT, SIG_DFL);/* allow user-generated core dumps */
	(void) signal (SIGALRM, SIG_IGN);
	if ((intproc = signal (SIGILL, SIG_DFL)) != SIG_DFL)
		(void) signal (SIGILL, intproc);/* allow exception processing */
	(void) signal (SIGTRAP, SIG_IGN);
	if ((intproc = signal (SIGIOT, SIG_DFL)) != SIG_DFL)
		(void) signal (SIGIOT, intproc);/* allow exception processing */
	if ((intproc = signal (SIGEMT, SIG_DFL)) != SIG_DFL)
		(void) signal (SIGEMT, intproc);/* allow exception processing */
	if ((intproc = signal (SIGFPE, SIG_DFL)) != SIG_DFL)
		(void) signal (SIGFPE, intproc);/* allow exception processing */
	(void) signal (SIGKILL, SIG_IGN);/* good luck! */
	if ((intproc = signal (SIGBUS, SIG_DFL)) != SIG_DFL)
		(void) signal (SIGBUS, intproc);/* allow exception processing */
/* somehow catching this tickles a bug in the kernel */
	if ((intproc = signal (SIGSEGV, SIG_DFL)) != SIG_DFL)
		(void) signal (SIGSEGV, intproc);
				/* allow exception processing */
	if ((intproc = signal (SIGSYS, SIG_DFL)) != SIG_DFL)
		(void) signal (SIGSYS, intproc);/* allow exception processing */
	(void) signal (SIGPIPE, SIG_IGN);
	(void) signal (SIGTERM, SIG_IGN);
#ifdef	SIGSTOP	
	(void) signal (SIGSTOP, SIG_IGN);
#endif
#ifdef	SIGTSTP 
	(void) signal (SIGTSTP, SIG_IGN);
#endif
#ifdef	SIGCONT 
	(void) signal (SIGCONT, SIG_IGN);
#endif
#ifdef	SIGCHLD 
	(void) signal (SIGCHLD, SIG_IGN);
#endif
#ifdef	SIGTTIN 
	(void) signal (SIGTTIN, SIG_IGN);
#endif
#ifdef	SIGTTOU 
	(void) signal (SIGTTOU, SIG_IGN);
#endif
#ifdef  SIGTINT 
	(void) signal (SIGTINT, SIG_IGN);
#endif
#ifdef	SIGXCPU	
	(void) signal (SIGXCPU, SIG_IGN);
#endif
#ifdef	SIGXFSZ 
	(void) signal (SIGXFSZ, SIG_IGN);
#endif
}
E 1
