h20861
s 00000/00000/00152
d D 1.2 84/08/06 12:55:10 disk 2 1
c added code to recognize ../ and ./ 
c The first version of this file got mangled somehow.
e
s 00152/00000/00000
d D 1.1 84/08/06 12:53:35 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/*
 * getsfn - make complete sdf filename from parts supplied in pname, plus
 * defaults.  Returned string is malloc'ed.
 * This is the routine that does all the work for setsfile().
 * sound file names consist of 4 parts: the device, path, body
 * and extension.  the device is (for instance) "/snd", the body is the
 * pname of the file, and the path is all the directories in between.  The
 * extension is always handled automatically, and is SNDEXT for the sound
 * file, and SDFEXT for the sound descriptor file.  (See libsf.h for the
 * current values of these definitions; they are ".snd" and ".sdf" at
 * CARL.)
 * 
 * Partial filenames are handled similarly to unix.  A full filename
 * specifies the device, path and body.  If a filename has a preceeding
 * '/' and what follows is not a soundfile device, it is taken as some
 * user's home directory; e.g. /dgl/examp/test ==> /snd/dgl/examp/test.  A
 * trailing, but no leading, slash indicates a subdirectory of the current
 * working directory; e.g., for user dgl, examp/test ==>
 * /snd/dgl/examp/test.  No slashes indicates a file in the current
 * working directory.  If no filename is supplied, a full path is
 * constructed from defaults.  The unix convention "./" and "../"
 * are not implemented.
 *
 */

/*
 * If the filename argument is NULL, the pname returned is equal to the
 * sum of the default device, path and body.
 * If the nobody argument is != 0, no body is attached to the
 * name returned, this is so that the path can be searched by itself for 
 * accessability, as for example by ckpath().
 */


char   *getsfn (name, nobody)
	char   *name;
	int     nobody;
{
	extern char *index(), *strcat(), *strcpy(), *relpath();
	extern struct sfstab  *getsfstab ();
	char   *a,
	       *fname,
	        tname[BUFSIZ],
	       *index (), *rindex (), *pname;
	struct defnamtab       *dfn,
	                       *getdefnam ();

	if ((dfn = getdefnam ()) == NULL)
		return (NULL);

	if (name == NULL)
		name = "";

	if (!strncmp(name, "..", 2)) {
		pname = relpath(name, dfn);
	} else {
		if ((pname = (char *) malloc ((unsigned) strlen (name) + 2)) 
		    == NULL)
			malerr("getsfn", 1);
		(void) strcpy (pname, name);
	}
	if (!strlen (pname)) {
	/* add everything */
		(void) strcpy (tname, dfn -> dev);
		(void) strcat (tname, dfn -> path);
		(void) strcat (tname, dfn -> body);
	}
	else
		if ((a = index (pname, '/')) == NULL) {
				/* no slashes means just a body */
		/* add dev, path to name */
			(void) strcpy (tname, dfn -> dev);
			(void) strcat (tname, dfn -> path);
			(void) strcat (tname, "/");
			(void) strcat (tname, pname);
		}
		else		/* there is a slash */
		/* is it first char in string, or later? */
			if (pname - a == 0) {
				/* it is first char *//* have we got a
				   device pname subtending? */
				struct sfstab  *sfs;
				/* ptr to list of all devs */
				int     hit = 0;
				char   *x;
				x = index (pname + 1, '/');
				if (x != NULL)
					*x = NULL;
				for (
					sfs = getsfstab (); 
					sfs != NULL; 
					sfs = sfs -> nxtsfstab
				    )
					if (!strcmp (sfs -> sdfdir, pname)) {
					/* we have a device in pname */
						hit++;
						break;
					}
				if (x != NULL)
					*x = '/';
				if (hit) {
				/* means we have a path with device */
					(void) strcpy (tname, pname);
				}
				else {
				/* no device name, must be someone's home
				   dir */
					(void) strcpy (tname, dfn -> dev);
					(void) strcat (tname, pname);
				}
			}
			else if (a - pname == 1 && *pname == '.') {
					/* name starts with ./ */
				(void) strcpy (tname, dfn -> dev);
				(void) strcat (tname, dfn -> path);
				(void) strcat (tname, "/");
				(void) strcat (tname, a+1);
			} else {	/* it is not first char in string,
				   indicating subdir of this user */
				(void) strcpy (tname, dfn -> dev);
				(void) strcat (tname, dfn -> path);
				(void) strcat (tname, "/");
				(void) strcat (tname, pname);
			}

	if (nobody) {
		a = rindex (tname, '/');
		if (a == NULL)
			return (NULL);
		*(a + 1) = NULL;
	}

	if ((fname = (char *) malloc ((unsigned) strlen (tname) + 1)) == NULL)
		malerr("getsfn", 1);
	(void) strcpy (fname, tname);
	free (pname);
	return (fname);
}

/*
 * main(argc,argv)
 * 	char **argv;
 * {
 * 	printf("%s\n", getsfn(argv[1], 0));
 * 	exit(0);
 * }
 */
E 1
