h61111
s 00001/00001/00146
d D 1.2 84/07/25 22:28:58 disk 2 1
c added malerr() call to getcdpath if malloc fails
e
s 00147/00000/00000
d D 1.1 84/07/25 13:42:33 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
extern char *malloc(), *calloc(), *realloc();

/*
 * Fill a static structure with the default parts of a sound file name.
 * It figures it out thus:
 * 	1) if an environment variable SFENVPATH exists, it may contain
 * 	up to three components, a device, a path, and a body, e.g.:
 * 	/snd/dgl/zilch/foo
 * 	^   ^          ^    
 * 	dev path       body
 * 	If the environment variable exists, parse out any of the components
 * 	that may be there, which may be just a device, or dev/path pair,
 * 	or all three parts.
 * 	2) get the actual owner of this process, and fetch the compiled-in
 * 	default name parts SDFDEV and SDFSFN.
 * 	3) form the union of (1) and (2) to form a complete default path name.
 * 	4) stuff the relevant parts of the static structure dnt.
 */


struct defnamtab       *dnt = NULL;

struct defnamtab       *
getdefnam () 
{
	extern char *strcpy(), *strcat(), *getprown(),
	       *getenv (), *getcdpath (), *calloc();
	extern struct sfstab *dirinfo();
	char   *ddev = SDFDEV,
	       *dbody = SDFSFN,
	       *dev, *ppath, *body, *own, *tmp = NULL;
	int     ns = 0;

	if (dnt != NULL)
		return (dnt);

	dev = ddev;
	own = getprown ();
	body = dbody;

	if ((ppath = getcdpath (own)) != NULL) {
		char   *c,
		       *d,
		       *e = NULL,
		       *f = NULL,
		       *str;
		int     ac = 0,
		        i;

		i = strlen (ppath) + 2;
		str = tmp = (char *) calloc ((unsigned) i, 
			(unsigned) sizeof(char));
		(void) strcpy (tmp, ppath);
		free (ppath);
		for (c = str + 1, d = str;; c++) {
			if (*c == '/' || *c == NULL) {
				*c = NULL;
				if (dirinfo (d)) {
					dev = d;
					e = c;
				}
				else
					if (isdir (str) == SDIR) {
						if (!ac++)
							own = d;
						f = c;
					}
					else {
						body = d;
						ns++;
					}
				if (!ns)
					*c = '/';
				d = c + 1;
				if (*(c + 1) == NULL)
					break;
			}
		}
		if (e != NULL)
			*e = NULL;
		if (f != NULL)
			*f = NULL;
	}
	if ((dnt = (struct defnamtab   *) malloc ((unsigned) 
		sizeof (struct defnamtab))) == NULL)
			malerr("getdefnam", 1);
	if ((dnt -> dev = (char *) malloc ((unsigned) strlen (dev)+1)) == NULL)
		malerr("getdefnam", 1);
	(void) strcpy (dnt -> dev, dev);
	if ((dnt -> path = (char *) malloc ((unsigned) strlen (own)+2)) == NULL)
		malerr("getdefnam", 1);
	*dnt -> path = '/';
	*(dnt -> path + 1) = NULL;
	(void) strcat (dnt -> path, own);
	if ((dnt -> body = (char *) malloc ((unsigned) strlen (body)+2))==NULL)
		malerr("getdefnam", 1);
	if (ns) {
		*dnt -> body = '/';
		*(dnt -> body + 1) = NULL;
	}
	else
		*dnt -> body = NULL;
	(void) strcat (dnt -> body, body);
	if (tmp != NULL)
		free (tmp);
	return (dnt);
}

char   *
        getcdpath (own)
char   *own;
{
	extern char *strcpy(), *strcat();
	FILE * fp;
	char   *namebuf = NULL;

	if ((namebuf = (char *) malloc (128)) == NULL)
D 2
		return (NULL);
E 2
I 2
		malerr("getcdpath", 1);
E 2
	(void) strcpy (namebuf, CDPREFIX);
	(void) strcat (namebuf, own);
	if ((fp = fopen (namebuf, "r")) == NULL)
		return (NULL);
	if (fgets (namebuf, 128, fp) != NULL) {
		(void) fclose (fp);
		return (namebuf);
	}
	else {
		(void) fclose (fp);
		free (namebuf);
		return (NULL);
	}
}

/*
 * main(argc, argv)
 * 	char **argv;
 * {
 * 	struct defnamtab *c, *getdefnam();
 * 
 * 	printf("dev= %s\n", getdefnam()->dev);
 * 	printf("path= %s\n", getdefnam()->path);
 * 	printf("body= %s\n", getdefnam()->body);
 * }
 */
E 1
