h55904
s 00124/00000/00000
d D 1.1 84/07/25 13:42:04 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>


/*
 * delsf - delete sound file.  If check!=0, write permission by the owner of
 * this process for the file is checked.  Then, if it is not in use by
 * some other process, the sound descriptor file is
 * removed and all its disk storage is returned to the free list.  
 * The spid field of the sndesc structure is checked against
 * the list of alive processes by pidexists().  If the process is still
 * alive, delsf() fails.
 * The return status is 0 if there was no such file, or if the deletion was
 * successful.  Returns > 0 if a "soft" error occurred, < 0 if a hard error.
 */

extern int      interlock;	/* from allocsf.c */
extern  FILE * lockfp;		/* from allocsf.c */
extern int      sferror;	/* from sopensf.c */
extern int      quitit ();

delsf (name, check)
char   *name;
int     check;
{
	FILE   *fp, *lockfopen ();
	int     fclose (), ck, rtn = 0;
	struct sndesc  *sfd = NULL,
	               *accesf ();
	char   *c,
	       *allocat (), *getsfile (), *allocname;
	struct dskblk  *head = NULL,
	               *rlist ();

	if (name == NULL)
		return (-1);

	if ((sfd = accesf (name)) == NULL) {
		if (sferror) {
			fprintf (stderr, "delsf: error accessing %s\n", name);
			return (-1);
		}
		else
			return (0);	/* no such file */
	}
	if (sfd -> rw != SFCLOSED) {	/* claims to not be closed */
		if (pidexists (sfd -> spid) == 0) {/* does proc exist? */
			fprintf (stderr, 
			    "delsf: file %s in use, can't delete.\n", 
			    name);
			return (1);	/* yes, i/o in progress */
		}
	}
 /* check write permission */
	if (check) {
		if (ck = ckprot (sfd -> sfn, sfd -> fprot, SFWRITE)) {
			if (ck == -1)
				fprintf (stderr, 
				    "delsf: protection error\n");
			else
				fprintf (stderr,
				    "delsf: no write permission on: %s\t%o\n",
				    sfd -> sfn, sfd -> fprot);
			freesfd (sfd);
			return (1);
		}
	}

 /* return file's list of cylinders to free list */
	if (sfd -> cp != NULL) {
	/* get allocation arena */
		setsfile (name);
		allocname = getsfile (ALLOCNAME);
		(void) umask (~(0664));
		ignall ();
		interlock = 1;	/* interlocked read/write, use global lockfp */
		if ((lockfp = fp = lockfopen (allocname, "r+")) == NULL) {
			fprintf (stderr, "delsf: can't open %s\n", allocname);
			rtn--;
			goto err;
		}
#ifdef DEBUG
		fprintf (stderr, "delsf: %s locked\n", sfd -> sfn);
#endif DEBUG
		if ((head = rlist (fp)) == NULL) {
			fprintf (stderr, "delsf: error reading %s\n", 
				allocname);
			rtn--;
			goto err;
		}
		if (cklist(allocname, head) != 0) {
			fprintf(stderr, "delsf: %s: contaminated free list\n",
				allocname);
			exit(1);
		}
	/* return blocks on sfd to UNUSED status in arena */
		if (markall (head, sfd, FALSE)) {
			fprintf (stderr, 
				"delsf: contaminated free list.\n");
			rtn--;
			goto err;
		}
	/* write revised allocation arena */
		if (wlist (head, sfd -> sfn, 1)) {
			fprintf (stderr, "delsf: error writing %s.\n",
					allocname);
			rtn--;
			goto err;
		}
		catchall (quitit);
	}

 /* delete sound descriptor file */
	c = allocat (sfd -> sfn, SDFEXT);
	if (unlink (c)) {
		fprintf (stderr, "delsf: unlink failed on: %s\n", sfd -> sfn);
		rtn--;
	}
	free (c);
	freesfd (sfd);
err: 
	return (rtn);
}
E 1
