/* %M%	%I%	(CARL)	%G%	%U% */
#include <carl/libsf.h>
#include <carl/dumpsf.h>
#include <sys/file.h>

/*
 * getinc, putinc - retrieve and deposit sound file dump info.  This
 * stuff manages file SFINCREM, which ordinarily lives on the 
 * "root" sound file directories of each mounted file system, such as
 * /snd and /snd1, and contains
 * one entry for each level of dump in the format: dumplevel, dumpdate and
 * tapeid.  Tapeid is a unique positive integer applied to each dump.
 * The structure returned contains both the tapeid for the level dump specified
 * in the argument, and the maximum tapeid for all levels.  When updating
 * this database with putinc(), the tapeid for the new dump should be the
 * maximum tapeid from the last call to getinc + 1.
 * Each successive run of dumpsf updates this info, and increments
 * max tapeid by 1.  Removing file SFINCREM causes it to start all over again.
 */

/*
 * putinc - update SFINCREM file for level dumplevel, copying info
 * for other levels.
 */

putinc(dumplevel, dumpdate, Tapeid, dev)
	int dumplevel; long dumpdate; int Tapeid; char *dev;
{
    FILE *fp, *fp1, *fopen();
    char buf[BUFSIZ], *fil1, *fil2, *getsfile();
    int tdumplevel; long tdumpdate; int tTapeid;
    int there = 0;

    setsfile(dev);
    fil1 = getsfile(SFINCREM);
    fil2 = getsfile(SFTMPINCREM);
    if (access(fil1, F_OK)) 	/* no file */
	{
	there++;
	fp1 = fopen(fil1, "w");
	if (fp1 == NULL)
	    {
	    perror(fil1);
	    fprintf(stderr, "putinc: error opening %s\n", fil1); 
	    exit(1);
	    }
	}
    else
	{
	fp = fopen(fil1, "r");
	if (fp == NULL)
	    {
	    perror(fil1);
	    fprintf(stderr, "putinc: error opening %s\n", fil1); exit(1);
	    }
	fp1 = fopen(fil2, "w");
	if (fp1 == NULL)
	    {
	    perror(fil2);
	    fprintf(stderr, "putinc: error opening %s\n", fil2); 
	    exit(1);
	    }
	while (fgets(buf, BUFSIZ, fp))
	    {	/* delete the old line for this level */
	    sscanf(buf, "%d%D%d", &tdumplevel, &tdumpdate, &tTapeid);
	    if (tdumplevel != dumplevel) fprintf(fp1, "%s", buf);
	    }
	}
    /* add the new line for this dump */
    fprintf(fp1, "%d\t%D\t%d\n", dumplevel, dumpdate, Tapeid);
    fclose(fp1);

    /* now make the temp. version the regular version */
    if (!there)
	{
	fclose(fp);
	if (unlink(fil1))
	    {
	    perror(fil1);
	    fprintf(stderr, "putinc: error unlinking %s\n", fil1); 
	    exit(1);
	    }
	if (link(fil2, fil1))
	    {
	    perror(fil2);
	    fprintf(stderr, "putinc: error linking %s\n", fil1); 
	    exit(1);
	    }
	if (unlink(fil2))
	    {
	    perror(fil2);
	    fprintf(stderr, "putinc: error unlinking %s\n", fil2); 
	    exit(1);
	    }
	}
   }
