/* %M%	%I%	(CARL)	%G%	%U% */
#include <carl/dumpsf.h>
#include <carl/libsf.h>

int 	tp;		/* fid to tape device */
int	lockup = 0;	/* if set, mlock the sound system while dumping */
int 	locked = 0;	/* was it locked when we got here? */
int	letemknow = 0;	/* notify operator flag */
char	operator[32];
int	ap = 0;
int	tapeno = 0;	/* current tape number */
int	density = 160;	/* density in 0.1" units */
long	now = 0, then = 0;
char	*timestr, *ctime(), *timc, *index(), *sfs;
struct incinfo *inc, *getinc();
extern char *arg_option;	/* from crack() */
extern int arg_index;
extern int norefupd;		/* from sclosesf() */
int verbose;
int estonly;
int bug;
int error;
extern float sizeup();		/* below */

/* pointer to doubly linked list of sfd's and sfe's which are heads of tapes */
struct theads
    {
    struct theads *nxtt;
    struct theads *lstt;
    struct sndesc *sfdt;
    struct sfentry *sfet;
    } *troot, *tcur;


main(argc, argv)
	int	argc;
	char	*argv[];
{
	extern char *rindex(), *malloc(), *calloc(), *strcpy();
	extern char *getprown();
	struct sfstab *dirinfo();
	float		fetapes;
	FILE		*fin = stdin;
	struct sndesc	*files();
	struct sndesc *rootsfd, *sfd;
	struct sfentry *rootsfe, *sfe, *msfds();
	char *sfestr(), ch, *masterlock;
	long int est();

	tsize = 2100*12L*10L;	/* underestimate! */
	tape = TAPE;
	rewtape = RWTAPE;
	increm = SFINCREM;

	/* dump level; default is to do a level 9 dump */ 
	incno = 9;
	uflag = 0;
	while ((ch = crack(argc, argv, "f|d|i|s|n|0123456789ulveb", 0)) != NULL)
	    {
	    switch (ch) 
		{
		case 'b':
		    bug++;			/* sigh... */
		    break;
		case 'd':			/* density, in bits per inch */
		    density = atoi(arg_option) / 10;
		    break;
		case 'e':
		    estonly++;
		    break;
		case 'f':			/* output file */
		    tape = arg_option;
		    break;
		case 'i':			/* read instead of stdin */
		    fin = fopen(arg_option, "r");
		    break;
		case 's':			/* tape size, feet */
		    tsize = atol(arg_option);
		    tsize *= 12L*10L;
		    break;
		case 'n':			/* notify operators */
		    letemknow++;
		    if (strlen(arg_option))
			strcpy(operator, arg_option);
		    else
			strcpy(operator, getprown());
		    break;
		case '0':			/* dump level */
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		    incno = ch - '0';
		    break;
		case 'u':			/* update sfdumpinfo file */
		    uflag++;
		    break;
		case 'l':
		    lockup = 1;
		    break;
		case 'v':
		    verbose = 1;
		    break;
		case EOF:
		default:
		    fprintf(stderr, "Exiting.\n");
		    exit(X_ABORT);
		}
	    }
	if(argc > arg_index) {
		argv++;
		argc--;
	}

	sfsetiname(*argv[0]);

	if ((rootsfd = files(fin)) == NULL)
		exit(1);
	if ((rootsfe = msfds(rootsfd)) == NULL) 
		exit(1);

	sfs = dirinfo(rootsfd->sfn)->sdfdir;
	inc = getinc(incno, sfs);		/* dump level */
	tapeid = inc->tapeidmax+1;	/* assign this dump a unique number */
	printf("This dump id number is: %d. Mark this on each tape.\n", tapeid);
	now = time((long *) NULL);
	timestr = ctime(&now);
	timc = index(timestr, '\n');
	*timc = NULL;
	printf("Date of this level %d dump: %s\n", incno, timestr);

	then = inc->dumpdate;
	timestr = ctime(&then);
	timc = index(timestr, '\n');
	*timc = NULL;
	printf("Date of last level %d dump: %s\n", incno, timestr);

	esize = est(rootsfd, rootsfe);
	if (esize <= 0)
		{
		error++;
		goto out;
		}

	fetapes = sizeup(esize);
	etapes = fetapes;		/* truncating assignment */
	etapes++;
	printf("estimated %ld tape blocks on %3.2f tape(s).\n", esize, fetapes);
	if (estonly) 
		goto out;

	if (lockup)	/* user wants it locked for this dump */
	    {		/* is it already locked?  then don't relock */
	    char *getsfile();
	    if (verbose) 
		fprintf(stderr, "dumpsf locking filesystem: %s\n", sfs);
	    masterlock = getsfile(MASTERLOCK);
	    locked = !access(masterlock, 0);
	    if (!locked)
		mlock(sfs, "Sound system is being dumped to tape.", 0);
	    }

	printf("Dumping to %s\n", tape);
	if (wtape(rootsfe, troot) != 0) 
		error++;

out:	norefupd = 1;	/* don't update time referenced in files */
	for (sfd = rootsfd, sfe = rootsfe; 
		sfd != NULL && sfe != NULL; 
		sfd = sfd->nxtsdf, sfe = sfe->nxtsfe)
	    {
	    if (bug) printf("closing: %s\n", sfd->sfn);
	    /* copy the relevant dump stuff into the sfd to be saved */
	    if (!error && !estonly)
		{
		sfd->tpkey = sfe->tapekey;
		sfd->dumpd = sfe->dumpdate;
		}
	    if (sclosesf(sfd))
		{ fprintf(stderr, "error closing %s\n", sfd->sfn); }
	    }

	if (lockup && !locked) 
		munlock();

	if (error) 
	    {
	    if (letemknow) 
		notify(operator, "dumpsf FAILED");
	    else
		fprintf(stderr, "dumpsf FAILED\n");
	    }
	else
	    {
	    if (incno >= 0)
		putinc(incno, now, tapeid, sfs);
	    if (letemknow) 
		notify(operator, "Dumpsf is done.");
	    else
		printf("Dumpsf is done.\n");
	    }
	exit(error);
}

/*
 * files - create linked list of all sdf files read from file open on fin.
 * returns ptr to doubly linked list of sfd's.  Sequential calls to opensf
 * automatically generates this chain.
 */

struct sndesc *files(fin)	/* read names of files to be dumped */
	FILE *fin;		/* from input fin */
{				/* returns ptr to linked list of sfd's */
    char tmp[BUFSIZ];
    struct sndesc *sfd, *sopensf(), *rootsfd = NULL;
    static int first = 0;

    while (fgets(tmp, BUFSIZ, fin) != NULL)
	{
	char *c;
	c = (char *) rindex(tmp, '\n');	/* zap the return */
	if (c != NULL) *c = NULL;
	if (strlen(tmp) == 0)		/* skip blank lines */
		continue;
	if ((sfd = sopensf(tmp, "r", NULL)) == NULL || sfd->err != 0)
	    {
	    fprintf(stderr, "dumpsf: opensf failed on %s\n", tmp);
	    exit(1);
	    }
	if (!first)	/* first time */
		{ first++; rootsfd = sfd; }
	}
    return(rootsfd);
    }

struct sfentry *msfds(rootsfd)
	struct sndesc *rootsfd;
{
	struct sndesc *sfd;
	struct sfentry *sfe, *rootsfe = NULL, *mksfe();
	static int first = 0;
	for (sfd = rootsfd; sfd != NULL; sfd = sfd->nxtsdf)
	    if (!first)	/* first time */
		{
		first++;
		sfe = rootsfe = mksfe(sfd);
		if (sfe == NULL)
		    {
		    fprintf(stderr, "dumpsf: mksfe failed on %s\n", sfd->sfn);
		    exit(1);
		    }
		sfe->nxtsfe = sfe->lstsfe = NULL;
		}
	    else
		{		/* double-link, jump to next link */
		sfe->nxtsfe = mksfe(sfd);
		if (sfe->nxtsfe == NULL)
		    {
		    fprintf(stderr, "dumpsf: mksfe failed on %s\n", sfd->sfn);
		    exit(1);
		    }
		sfe->nxtsfe->lstsfe = sfe;
		sfe = sfe->nxtsfe;
		sfe->nxtsfe = NULL;
		}
	return(rootsfe);
	}

# define tbround(x)	((x + (TBLKLEN - 1)) / TBLKLEN)

long int
est(rootsfd, rootsfe)
	struct sndesc *rootsfd;
	struct sfentry *rootsfe;
{
	struct sndesc *sfd;
	struct sfentry *sfe;
	long int sndsize = 0, sdfsize = 0, sfesize = 0, tblksize = 0,
	    etape = 0, oetape = 0, tblks = 0, thistape = 0, dumpmsfd = 0;
	long int estunix();
	double detape;

	/* find out how big the dumpmsfd will be */
	for (sfe = rootsfe; sfe != NULL; sfe = sfe->nxtsfe)
	    dumpmsfd += strlen(sfe->entry)+1;
	dumpmsfd = tbround(dumpmsfd);

	/* step through both lists, figure what fits on one tape */
	tblksize = dumpmsfd;	/* add in offset for dumpmsfd */
	markthead(rootsfd, rootsfe);	/* the tape starts with this file */
	for (sfd = rootsfd, sfe = rootsfe; 
	     sfd != NULL && sfe != NULL; 
	     sfd = sfd->nxtsdf, sfe = sfe->nxtsfe)
	    {
	    /* point to where this file is in the world at large */
	    /* first calc. size of list of all files on this tape */
	    /* size of sdf and sound samples, in bytes */
	    sndsize = sfd->fs*((sfd->pm==PM16BIT)?sizeof(short):sizeof(float));
	    sndsize = tbround(sndsize);
	    sdfsize = estunix(sfe->nsdf)+1;	/* size of sdf file in bytes */
	    sdfsize = tbround(sdfsize);
	    sfesize = strlen(sfe->entry)+1;	/* len of msfd entry in bytes */
	    sfesize = tbround(sfesize);
	    tblks = sndsize + sdfsize + sfesize; 
	    /* tblks +=20;			/* add some slop */
	    tblksize += tblks;
	    thistape += tblks;
	    if (verbose)
		printf("size=%8d\tso far=%8d\tfile= %s\n",
		    tblks, thistape, sfd->sfn);
	    if (sizeup(tblks) >= 1.0)
		{
		fprintf(stderr, "DUMPSF: FILE %s TOO BIG: %f tapes\n",
			sfd->sfn, sizeup(tblks));
		return(-1);
		}
	    detape = sizeup(tblksize);
	    etape = detape;	/* truncating assignment */
	    if (etape > oetape)
		{
		oetape = etape;	/* reset this test */
		thistape = tblks;  /* set size used on new tape */
		markthead(sfd, sfe);
		if (verbose)
		    printf("new tape starting with %s\n", sfd->sfn);
		}
	    /* say where this file is in the dump */
	    sfe->tapekey = 0;		/* this dump superceeds last, if any */
	    TAPEID(sfe->tapekey, tapeid);/* store number of this dump */
	    TAPESEQ(sfe->tapekey, etape);/* store which tape in dump this is */
	    DUMPLEVEL(sfe->tapekey, incno);/* dump level */
	    sfe->dumpdate = now;	/* and dump date */
	    }
	return(tblksize);
	}

long int estunix(name)
	char *name;
{
	struct stat buf;
	if (name ==  NULL) return(-1);
	if (stat(name, &buf) < 0)
	    {
	    fprintf(stderr, "dumpsf: stat failed on file: %s.\n", name);
	    exit(1);
	    }
	return(buf.st_size);
	}

float sizeup(fsize)
	long fsize;
{
	double detape;

	/*
	 *	fsize is typically about 5% too low; we frob it here
	 */
	fsize += ((5*fsize)/100);
	detape =
	    (	 fsize			/* blocks */
		    *TBLKLEN		/* bytes / block */
		    *(1.0/density)	/* 0.1" / byte */
	      +
		     fsize		/* blocks */
		    *(1.0/NTREC)	/* IRG's / block */
		    *7			/* 0.1" / IRG */
	    ) * (1.0 / tsize )		/* tape / 0.1" */
	;
	return(detape);
}

close_rewind()
{
	if (close(tp))
	    { perror("dumpsf:close_rewind:close"); return(-1); }
/* changed to open for writing [rcw] */
	if ((tp = open(rewtape, 1))<0)
	    { perror("dumpsf:close_rewind:open"); return(-1); }
	if (close(tp))
	    { perror("dumpsf:close_rewind:close"); return(-1); }
	if (++tapeno >= etapes) 
	    return(0);
	else 
	    {
	    if (letemknow)
		notify(operator, "dumpsf: change tape!");
	    printf("Change tape, mount tape #%d\n", tapeno);
	    }
	do
	    {
	    if (yes("Is the new tape mounted and ready to go? (type y) ", ap))
		    break;
	    if (yes("Do you want to abort?", ap))
		    return(-1);
	    } 
	while (1);
	if ((tp = open(tape, 1)) < 0)
	    { perror("dumpsf:close_rewind:open"); return(-1); }
	return(0);
	}

wtape(rootsfe, troot)
	struct sfentry *rootsfe;
	struct theads *troot;
{
	struct sndesc *sfd;
	struct sfentry *sfe;
	struct theads *tptr;
	static int first = 0;
	int wsize;
	char tmpstr[512];

	/* open tape */
	if ((tp = open(tape, 1))<0)
	    { perror("dumpsf:wtape:open"); return(-1); }

	first = 0;
	/* write dump master file directory on first tape only */
	if (!first)	/* first time */
	    {
	    first++;
	    timestr = ctime(&now);
	    timc = index(timestr, '\n');
	    if (timc != NULL) *timc = NULL;
	    sprintf(tmpstr,
		"%s\n%s %d, %s %d, %s %s, %s %d %s %d\n",
		SNDUMPHED,
		"tapeid", tapeid, "level", incno, "date", timestr, "tape", 
		tapeno+1, "of", etapes);
	    if (wbuf(tp, tmpstr))
		return(-1);
	    for ( sfe = rootsfe; sfe != NULL; sfe = sfe->nxtsfe )
		{
		char *tmp;
		tmp = sfestr(sfe);/* sfe->entry doesn't reflect dump info yet */
		if (tmp == NULL)
			{
			fprintf(stderr, "wtape: sfestr failed\n");
			return(-1);
			}
		wsize = strlen(tmp);
		if (wsize <= 0)
			{
			fprintf(stderr, "wtape: 0 length sfe\n");
			return(-1);
			}
		if (wbuf(tp, tmp))
		    return(-1);
		free(tmp);
		}
	    if (flushbuf(tp))
		return(-1);
	    if (close(tp))
		{ 
		perror("dumpsf:wtape:close"); 
		return(-1);
		}
	    if ((tp = open(tape, 1))<0)
		{ 
		perror("dumpsf:wtape:open"); 
		return(-1);
		}
	    }

	/* loop through each tape */
	for ( tptr = troot; tptr != NULL; tptr = tptr->nxtt )
	    {
	    printf("Writing tape %d\n", tapeno+1);
	    /* write tape header */
	    sprintf(tmpstr, "%s\n%s %d, %s %s, %s %d %s %d\n",
		SNDTAPEHED, "level", incno, "date", timestr, "tape", 
		tapeno+1, "of", etapes);
	    if (wbuf(tp, tmpstr))
		return(-1);
	    for ( sfe = tptr->sfet; 
		  sfe != NULL && sfe != tptr->nxtt->sfet; 
		  sfe = sfe->nxtsfe )
	        {
		char *tmp;
		tmp = sfestr(sfe);/* sfe->entry doesn't reflect dump info yet */
		if (wbuf(tp, tmp))
		    return(-1);
		free(tmp);
		}
	    if (flushbuf(tp))
		return(-1);
	    if (close(tp))
		{ 
		perror("dumpsf:wtape:close"); 
		return(-1);
		}
	    if ((tp = open(tape, 1))<0)
		{ 
		perror("dumpsf:wtape:open"); 
		return(-1);
		}

	    /* write individual files */
	    for ( sfe = tptr->sfet, sfd = tptr->sfdt;
		      sfd != NULL && sfd != tptr->nxtt->sfdt;
		  sfe = sfe->nxtsfe, sfd = sfd->nxtsdf )
		{
		/* write sound file descriptor on tape */
		if (rwsdf(sfe) == -1)
			{ 
			printf("dumpsf:rwsdf failed\n");
			return(-1);
			}
		/* write sound samples */
		if (rwsnd(sfd) == -1)
			{ 
			printf("dumpsf:rwsnd failed\n");
			return(-1);
			}
		}
	    if (close_rewind() != 0)
		return(-1);
	    }
    return(0);
    }


markthead(sfd, sfe)
	struct sndesc *sfd; struct sfentry *sfe;
{
    if (troot == NULL)
	{
	tcur = troot = (struct theads *) malloc (sizeof(struct theads));
	troot->nxtt = NULL;
	troot->lstt = NULL;
	troot->sfdt = sfd;
	troot->sfet = sfe;
	}
    else
	{
	tcur->nxtt = (struct theads *) malloc (sizeof(struct theads));
	tcur->nxtt->lstt = tcur;
	tcur = tcur->nxtt;
	tcur->sfdt = sfd;
	tcur->sfet = sfe;
	tcur->nxtt = NULL;
	}
    }

rwsdf(sfe)
	struct sfentry *sfe;
{
	char *sdfbuf;
	int sdfid, n; 
	int sdflen; 
	extern long estunix();
	sdflen = estunix(sfe->nsdf);
	sdfbuf = (char *) calloc(sdflen+1, sizeof(char));
	if (sdfbuf == NULL)
	    { fprintf(stderr, "dumpsf: out of memory\n"); return(-1); }
	if ((sdfid = open(sfe->nsdf, 0)) < 0)
	    { perror("dumpsf:rwsdf:open"); return(-1); }
	n = read(sdfid, sdfbuf, sdflen);
	if (n != sdflen)
	    {
	    perror("dumpsf:rwsdf:read");
	    fprintf(stderr, "dumpsf: read failed on: %s, n=%d\n", sfe->nsdf, n);
	    return(-1);
	    }
	if (close(sdfid))
	    { perror("dumpsf:rwsdf:close"); return(-1); }
	if (verbose)
	    printf("Writing:\t%s\n",sfe->nsdf);
	if (wbuf(tp, sdfbuf))
	    return(-1);
	if (flushbuf(tp))
	    return(-1);
	free(sdfbuf);
	if (close(tp))
	    { perror("dumpsf:close:rwsdf"); return(-1); }
	if ((tp = open(tape, 1))<0)
	    { perror("dumpsf:rwsdf:open"); return(-1); }
	return(0);
	}

rwsnd(sfd)
    struct sndesc *sfd;
{
    char buf[TBLKLEN];
    int i, blen, xfrsiz, sampsiz, rtn;
    char *ipak = "f";
    if (sfd->pm == PM16BIT) 
	{
	*ipak = 's';
	sampsiz = sizeof(short);
	}
    else sampsiz = sizeof(float);
    xfrsiz = sizeof(buf)/sampsiz;

    for (   i = 0, blen = lmin(xfrsiz, sfd->fs - i); 
	    blen > 0 && sfd->eof == FALSE;
	    i += blen, blen = lmin(xfrsiz, sfd->fs - i)) 
	{
	rtn = sndi(sfd, buf, i, blen, ipak);
	if (rtn < 0)
	    {
	    fprintf(stderr,"%s\t%o\t%o\n","dumpsf: sndi read error",
		sfd->err, rtn);
	    return(-1);
	    }
	/* if (write(tp, buf, blen*sampsiz)<blen*sampsiz) */
	if (write(tp, buf, xfrsiz*sampsiz)<xfrsiz*sampsiz)
	    { perror("dumpsf:rwsnd:write"); return(-1); }
	}
    if (close(tp))
	{ perror("dumpsf:rwsnd:close"); return(-1); }
    if ((tp = open(tape, 1))<0)
	{ perror("dumpsf:rwsnd:open"); return(-1); }
    return(0);
    }

/*
 * note 1
 * dumpsf - dump csound files to tape
 * 
 * Tape format:
 *     tape_1:
 * 	<dump_master_directory> EOF
 * 	<tape_master_directory> EOF
 * 	<sdf_file_1> EOF
 * 	<sound_samples_1> EOF
 * 	<sdf_file_2> EOF
 * 	<sound_samples_2> EOF . . .
 * 	<sdf_file_M> EOF
 * 	<sound_samples_M> EOF
 * 	EOF
 *     tape_2:
 * 	<tape_master_directory> EOF
 * 	<sdf_file_1> EOF
 * 	<sound_samples_1> EOF
 * 	<sdf_file_2> EOF
 * 	<sound_samples_2> EOF . . .
 * 	<sdf_file_N> EOF
 * 	<sound_samples_N> EOF
 * 	EOF
 *     tape_3:
 * 	etc.
 * 
 *     <dump_master_directory>:
 * 	<master_header> <newline>
 * 	<sound_file_entry> <newline> . . .
 *     
 *     <master_header>:
 * 	"sndump: dump directory:"
 *     <tape_header>:
 * 	"sndump: tape directory:"
 *     <sound_file_entry>
 * 	format as written in struct sfentry ->entry field by mksfe()
 *     <sdf_file>
 * 	format as written by wsdf();
 */

 /*
  * note 2
  * it seems that if a file is too small by some arbitrary UNIX
  * standard of size, that the tape controller may treat the file
  * as noise instead of as a file.  This hack attempts to make the
  * file big enough.
  */
