/* %M%	%I%	(CARL)	%G%	%U% */
/*
 * chownsf owner files
 *  change owner of files
 */
#include <stdio.h>
#include <carl/libsf.h>

char *ms;

main(argc,argv)
char **argv;
{
	extern char *malloc(), *strcpy();
	CSNDFILE *sfd;
	register i;
	register char *p;
	int status = 0;

	if (argc < 3) {
		fprintf(stderr, "Usage: chownsf owner file ...\n");
		exit(++status);
	}

	if (!ingroup(SUPERGROUP)) {
		fprintf(stderr, "chownsf: sorry, you are not a superuser\n");
		exit(++status);
	}

	ms = argv[1];
	for (i = 2; i < argc; i++) {
		p = argv[i];
		if ((sfd = sopensf(p, "r", (struct sndesc *) NULL)) == NULL) { 
			fprintf(stderr, "chownsf: sopensf failed on %s\n", p);
			status++;
			continue;
		}
		free(sfd->sfown);
		if ((sfd->sfown = (char *) malloc((unsigned) strlen(ms)+1)) 
		    == NULL)
			malerr("chownsf", 1);
		(void) strcpy(sfd->sfown, ms);
		if (sclosesf(sfd) != 0) {
			fprintf(stderr, "chownsf: sclosesf failed\n");
			exit(++status);
		}
	}
	exit(status);
}
