#include <carl/cmusic.h>

#define incr 1/145
#define length 3072

var 0 s1 "/snda/dolson/16.A";
var 0 s2 "/snda/dolson/16.F";

set stereo;
set list = 16gg.l; 
set sfbufsize = 2K;
set blocklength = 512;

ins 0 left;
	sndfile b1 p10 incr s1 1 p5 p6 d d;
	sndfile b2 1 incr s2 1 p5 p6 d d;
	mult b9 b2 1Hz;
	mult b10 b9 p7;
	osc b11 b10 p8 p9 d;
	adn b12 b9 b11;
	osc b13 b1 b12 f1 d;
	out b13 0;
end;

ins 0 right;
	sndfile b1 p10 incr s1 1 p5 p6 d d;
	sndfile b2 1 incr s2 1 p5 p6 d d;
	mult b9 b2 1Hz;
	mult b10 b9 p7;
	osc b11 b10 p8 p9 d;
	adn b12 b9 b11;
	osc b13 b1 b12 f1 d;
	out 0 b13;
end;

SINE(f1);
GEN1(f2) 0,0 .95,1 1,0; 
GEN1(f3) 0,0 .45,1 1,0; 

{
note 0 left    5.422*5   0*length p5+(length-1) .00  p4sec 3  .9;

note 0 right   5.422*5   1*length p5+(length-1) .00  p4sec 2  .6;
note 0 right   5.422*5   1*length p5+(length-1) .02  p4sec 2  .4;

note 0 left    5.422*5   2*length p5+(length-1) .00  p4sec 3  .6;
note 0 left    5.422*5   2*length p5+(length-1) .02  p4sec 3  .4;

note 0 right   5.422*5   3*length p5+(length-1) .00  p4sec 2  .6;
note 0 right   5.422*5   3*length p5+(length-1) .02  p4sec 2  .4;

note 0 left    5.422*5   4*length p5+(length-1) .00  p4sec 3  .6;
note 0 left    5.422*5   4*length p5+(length-1) .02  p4sec 3  .4;
}

note 0 right   5.422*5   5*length p5+(length-1) .00  p4sec 2  .6;
note 0 right   5.422*5   5*length p5+(length-1) .02  p4sec 2  .4;

note 0 left    5.422*5   5*length p5+(length-1) .00  p4sec 3  .6;
note 0 left    5.422*5   5*length p5+(length-1) .02  p4sec 3  .4;
ter;
