#include <carl/cmusic.h>
{
set stereo;
}
#define R 128
set srate R;
#define T (1/R)

ins 0 pv;
    osc b2 p5 p6 f1 d;    {signal source}
    osc b3 b2 p7 f2 d;    {cosine multiplier; b3 is a}
    osc b4 b2 p7 f3 d;    {sin multiplier; b4 is b}
    diff b5 b3 d;         {b5 is del a}
    diff b6 b4 d;         {b6 is del b}
    mult b7 b4 b5;        {b7 is b * del a}
    mult b8 b3 b6;        {b8 is a * del b}
    neg  b8 b8;           {b8 = -(a * del b)}
    adn  b8 b7 b8;        {b8 = (b del a) - (a del b)}
    square b9 b3;         {b9 = a^2}
    square b10 b4;        {b10 = b^2}
    adn    b10 b9 b10;    {b10 = a^2 + b^2}
    mult   b11 b10 T;     {b11 = (a^2 + b^2)*T}
    div    b12 b8 b11 d;  {b12 = phase derivative}
    sqroot b13 b10;       {b13 = amplitude}
    mult   b14 b12 T*1024; {scale phase by T and 2 pi}
    osc    b15 b13 p7 f2 b14; {phase-modulated synthesis oscillator}
    out b15 ;
end;

{
gen 0 gen5 f1 1,1,45Deg ;      {source signal}
NORM(f1);
}
SINE(f1);
gen 0 gen5 f2 1,1,90Deg;  {cosine modulator}
gen 0 gen5 f3 1,1,0;      {sine modulator}

note 0 pv 1 .5 8Hz 8Hz;

ter;
