#include <carl/cmusic.h>
set stereo;
set funclength = 8K;
set list = jazz.list;
set revscale = .1;
set t60 = 3;
set cutoff = -40dB;
set room = 3,3 -3,3 -3,-3 3,-3;
set speakers = 3,3 -3,3;

ins 0 bass;
{env}		osc  b1 p6 p5 f2 d;
{carrier} 	osc  b1 b1 p7 f1 d;
		SPACE(b1,1) p8 p9 270Deg 1 -18dB;
end;

GEN5(f1) SAW(1) SAW(2) SAW(3) SAW(4) SAW(5) SAW(6) SAW(7) SAW(8)
SAW(9) SAW(10) SAW(11) SAW(12) SAW(13) SAW(14) SAW(15) SAW(16) SAW(17)
SAW(18) SAW(19) SAW(20);
NORM(f1);

GEN4(f2) 0,0 -12 .001,1 -1 1,0;

#define X(c)-32+8*c
#define Y(c)c+6
#define PX(theta)20*cos((-180+20*theta)Deg)
#define PY(theta)20*sin((20*theta)Deg)
#define T (240MM)

note 0 bass 1*T p4sec 0dB C(-1) X(0) Y(0);
note p2+1*T bass 1*T p4sec 0dB Cs(-1) X(1) Y(0);
note p2+1*T bass 1*T p4sec 0dB D(-1) X(2) Y(0);
note p2+1*T bass 1*T p4sec 0dB Ds(-1) X(3) Y(0);
note p2+1*T bass 1*T p4sec 0dB E(-1) X(4) Y(0);
note p2+1*T bass 1*T p4sec 0dB F(-1) X(5) Y(0);
note p2+1*T bass 1*T p4sec 0dB Fs(-1) X(6) Y(0);
note p2+1*T bass 1*T p4sec 0dB G(-1) X(7) Y(0);
sec;
sec 2;

note 0 bass 1*T p4sec 0dB C(-1) PX(0) PY(0);
note p2+1*T bass 1*T p4sec 0dB Cs(-1) PX(1) PY(1);
note p2+1*T bass 1*T p4sec 0dB D(-1) PX(2) PY(2);
note p2+1*T bass 1*T p4sec 0dB Ds(-1) PX(3) PY(3);
note p2+1*T bass 1*T p4sec 0dB E(-1) PX(4) PY(4);
note p2+1*T bass 1*T p4sec 0dB F(-1) PX(5) PY(5);
note p2+1*T bass 1*T p4sec 0dB Fs(-1) PX(6) PY(6);
note p2+1*T bass 1*T p4sec 0dB G(-1) PX(7) PY(7);
{
note p2+p4-.5*T bass 1*T p4sec -1dB E(-3) X(1) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB G(-3) X(2) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB A(-3) X(3) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB Bf(-3) X(4) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB A(-3) X(3) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB G(-3) X(2) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB E(-3) X(1) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB C(-3) X(0) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB E(-3) X(1) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB G(-3) X(2) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB A(-3) X(3) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB Bf(-3) X(4) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB A(-3) X(3) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB G(-3) X(2) Y(0);
note p2+p4-.5*T bass 1*T p4sec -1dB E(-3) X(1) Y(0);
}

sec;
ter 4;
