/* Spatial Processing Unit Generator */

#include "mm.head.h"
#include "ug.head.h"
#include <stdio.h>
#include <math.h>

#define NSKIP	1
#define DBUF	2
#define DLEN	3
#define NOW	4
#define DARRAY	5
#define CARRAY	6
#define AARRAY	7
#define FARRAY	8
#define XS	9
#define YS	10
#define THETAS	11
#define AMPS	12
#define BACKS	13
#define X	14
#define Y	15
#define THETA   16
#define AMP     17
#define BACK    18


#define CI	.00029851	/* 1/335 (meters per second) */
#define PI2	6.283185308
#define PI	3.141592654
#define IPI	.318309886
#define D270	4.712388981
#define D90	1.570796327
#define DIST(x1,y1,x2,y2) sqrt( (double) ((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2)))
#define TAU	50		/* milliseconds in cross-fade */

space

UGHEAD{
    UGINIT;
    float *Out = Outblock, *Grev = Grevblock;
    float *dbuf;
    double ***cut, ***delay, ***atten, ***fader, delsamp;
    double *xs, *ys, *ts, *as, *bs;
    double maxdist, maxdelay, d, chanval[4], radiant;
    double ***fp3alloc(), do_delay();
    int change, skip, inside;
    long dlen, now, j, k, nrv, dim, c, r, s, ns;
    double fade, rx, ry, dx, dy, dt, phi, getcut(), val;

    if(STARTNOTE){
	Spacewason = Spaceon = 1;	/* Turn on global reverberator */
	maxdist = 0.;
	for(j=0; j<NAs; j++){ /* Find largest distance in acoustic space */
	    for(k=0; k<NAs; k++){
		if(j == k) continue;
		d = DIST(Ax[j], Ay[j], Ax[k], Ay[k]);
		if(d > maxdist) maxdist = d;
	    }
	}
	maxdelay = 2.*maxdist;
	dlen = LVAL(DLEN) = maxdelay*Srate*CI + 0.5;
	now = LVAL(NOW) = 0;
	FPTR(DBUF) = (float *) calloc(dlen, sizeof(float));
	nrv = (narg - X)/5;	/* number of radiation vectors specified */
	ns = NAs + 1; 	/* Extra surface is for direct path values */
	DPTR(CARRAY) = (double *) fp3alloc(nrv,ns,Nchan);
	DPTR(DARRAY) = (double *) fp3alloc(nrv,ns,Nchan);
	DPTR(AARRAY) = (double *) fp3alloc(nrv,ns,Nchan);
	DPTR(FARRAY) = (double *) fp3alloc(nrv,ns,Nchan);
	DPTR(XS) = (double *) calloc(nrv, sizeof(double));
	DPTR(YS) = (double *) calloc(nrv, sizeof(double));
	DPTR(THETAS) = (double *) calloc(nrv, sizeof(double));
	DPTR(AMPS) = (double *) calloc(nrv, sizeof(double));
	DPTR(BACKS) = (double *) calloc(nrv, sizeof(double));
    }
    dbuf = FPTR(DBUF);
    dlen = LVAL(DLEN);
    now = LVAL(NOW);
    cut = (double ***) DPTR(CARRAY);
    delay = (double ***) DPTR(DARRAY);
    atten = (double ***) DPTR(AARRAY);
    fader = (double ***) DPTR(FARRAY);
    nrv = (narg - X)/5;
    xs = DPTR(XS);
    ys = DPTR(YS);
    ts = DPTR(THETAS);
    as = DPTR(AMPS);
    bs = DPTR(BACKS);
    ns = NAs + 1;
    skip = VAL(NSKIP);
    fade = 1000./(TAU*Srate);
    UGLOOP{
	dbuf[now] = VAL(0); /* install current sample in delay buffer */
	if(i%skip == 0){
	    change = 0;
	    for(j=0; j<nrv; j++){ register place = j*5;
		if(xs[j] != VAL(X+place)){change=1; xs[j]=VAL(X+place);}
		if(ys[j] != VAL(Y+place)){change=1; ys[j]=VAL(Y+place);}
		if(ts[j] != VAL(THETA+place)){change=1; ts[j]=VAL(THETA+place);}
		if(as[j] != VAL(AMP+place)){change=1; as[j]=VAL(AMP+place);}
		val = sqrt( (double) VAL(BACK+place));
		if(bs[j] != val){change=1; bs[j]=val;}
	    }
/*
 * get the cut, delay, and atten arrays computed for all current
 * radiation vectors, surface reflection (and direct) paths, and 
 * channels
 */
/* do only one first loop or when something varies */
/* do direct paths first */
	    if(change || i==0){
		for(r=0; r<nrv; r++)
		 for(c=0; c<Nchan; c++){
		    cut[r][0][c] = getcut(xs[r],ys[r],Sx[c],Sy[c],c);
		    d = DIST(xs[r],ys[r],Sx[c],Sy[c]);
		    delay[r][0][c] = d*Srate*CI;
		    if(bs[r] < 1.0){
			dy = ys[r] - Sy[c];
			dx = xs[r] - Sx[c];
			phi = dx ? atan(dy/dx) : (dy > 0 ? D270 : D90 );
			dt = fabs(ts[r] - phi);
			if(dt > PI)dt = PI2 - dt;
			radiant = 1 + (bs[r] - 1)*dt*IPI;
			radiant *= radiant;
/*
 * attenuation depends on amplitude of vector, angle of vector,
 * and distance to vector origin
 */
			atten[r][0][c] = as[r]*radiant/(1.+d);
		    } else atten[r][0][c] = as[r]/(1.+d);
		}
/* now do surface reflections */
		for(r=0; r<nrv; r++)
		 for(s=1; s<ns; s++)
		  for(c=0; c<Nchan; c++){
		    getrefl(xs[r],ys[r],Sx[c],Sy[c],s-1,&rx,&ry);
		    cut[r][s][c] = 0.;
		    if( getcut(rx,ry,Sx[c],Sy[c],c) != 0.)
		     if(getcut(xs[r],ys[r],rx,ry,c) != 0.) cut[r][s][c] = 1.;
		    d = DIST(xs[r],ys[r],rx,ry)+DIST(rx,ry,Sx[c],Sy[c]);
		    delay[r][s][c] = d*Srate*CI;
		    if(bs[r] < 1.0){
			dy = ys[r] - ry;
			dx = xs[r] - rx;
			phi = dx ? atan(dy/dx) : (dy > 0 ? D270 : D90 );
			dt = fabs(ts[r] - phi);
			if(dt > PI)dt = PI2 - dt;
			radiant = 1 + (bs[r] - 1)*dt*IPI;
			radiant *= radiant;
			atten[r][s][c] = as[r]*radiant/(1.+d);
		    } else atten[r][s][c] = as[r]/(1.+d);
		}
	    }
	}
/*
 *     pra(cut, delay, atten, nrv, ns, xs, ys, ts, as);
 */
	for(c=0; c<Nchan; c++){
	    chanval[c] = 0;
	    for(r=0; r<nrv; r++)
	     for(s=0; s<ns; s++){
		d = delay[r][s][c];
		delsamp = do_delay(dbuf,dlen,now,d);
		if(s == 0){
		    if(!within(xs[r],ys[r])){  /* Outside? */
			*Grev += delsamp * atten[r][s][c];
			inside = 0;
		    } else {
			inside = 1;
		    }
		} else if(!inside) 
			*Grev += delsamp * atten[r][s][c];
		if(cut[r][s][c] == 1.){
		    if(fader[r][s][c] < 1.){
			fader[r][s][c] += fade;
			if(fader[r][s][c] > 1.)fader[r][s][c] = 1.;
			val = delsamp * atten[r][s][c] * fader[r][s][c];
			chanval[c] += val;
			if(inside) *Grev += val;
		    } else {
			val = delsamp * atten[r][s][c];
			chanval[c] += val;
			if(inside) *Grev += val;
		    }
		} else if(fader[r][s][c] > 0.){
			fader[r][s][c] -= fade;
			if(fader[r][s][c] < 0.)fader[r][s][c] = 0.;
			val = delsamp * atten[r][s][c] * fader[r][s][c];
			chanval[c] += val;
			if(inside) *Grev += val;
		}
	    }
	    *Out++ += chanval[c];
	    if(fabs(chanval[c]) > Maxecho)Maxecho = chanval[c];
	}
	Grev++;
	now -= 1;
	if(now < 0)now = dlen - 1;
	LVAL(NOW) = now;
	LVAL(DLEN) = dlen;
	UGEND(0);
    }
    if(ENDNOTE){
	free(dbuf);
	fp3free(cut,nrv,ns,Nchan);
	fp3free(delay,nrv,ns,Nchan);
	fp3free(atten,nrv,ns,Nchan);
	fp3free(fader,nrv,ns,Nchan);
	free(xs);
	free(ys);
	free(ts);
	free(as);
	free(bs);
    }
}

pra(cut, delay, atten, nrv, ns, x, y, t, a)
 int nrv, ns; double ***cut, ***delay, ***atten, *x, *y, *t, *a;
{
 int r,s,c; double d, rx, ry, getcut();
 static int count = 0;
 /*
fprintf(stderr,"[%d] %o %o %o %o %o %o %o\n",count++,cut,delay,atten,x,y,t,a);
*/
    for(r=0; r<nrv; r++){
	for(s=0; s<ns; s++){
	    /*
	    fprintf(stderr,"r=%d, s=%d, c=* :",r,s);
	    fprintf(stderr,"  cut:");
	    for(c=0; c<Nchan; c++){
		fprintf(stderr," %.0f",cut[r][s][c]);
	    }
	    */
	    fprintf(stderr,"  delay:");
	    for(c=0; c<Nchan; c++){
		fprintf(stderr," %.3f",delay[r][s][c]);
	    }
	    /*
	    fprintf(stderr,"  atten:");
	    for(c=0; c<Nchan; c++){
		fprintf(stderr," %f",atten[r][s][c]);
	    }
	    */
	fprintf(stderr,"\n");
	}
    fprintf(stderr,"\n");
    fprintf(stderr,"\n");
    }
}
/*
 * within return 1 if point x,y is inside listening space, else 0
 */
within(x,y) double x,y;{
    if(x < Lx[0] && y < Ly[0])
     if(x > Lx[1] && y < Ly[1])
      if(x > Lx[2] && y > Ly[2])
       if(x < Lx[3] && y > Ly[3])
	return(1);
    return(0);
}
/*
 * getcut returns 0.0 if the line defined by x1,x2 and x2,y2 crosses 
 * (cuts) any surface of the inner room, and 1.0 if it doesn't
 */
double getcut(x1,y1,x2,y2,c) double x1,y1,x2,y2; int c;{
 int l1vert, i;
 double dx1, dy1, b1, m1, mn1, mn2, mx1, mx2, ycutq, cx, cy;
 static int first = 1;
 static int l2vert[4];
 static double dx2[4], dy2[4], b2[4], m2[4];
 static double lx2[4], ly2[4], lx1[4], ly1[4];
#define SMIN(a,b) (a < b ? a : b)
#define SMAX(a,b) (a > b ? a : b)
#define INRANGE(a,b,c) (b < c ? a >= b && a <= c : a >= c && a <= b)
#define NOTSPKR(x,y)!(fabs(x-Sx[c])<.0001 && fabs(y-Sy[c])<.0001)
#define CUT return(0.)
#define NOCUT return(1.)

/* calculate equation of given line */
    l1vert = 0;
    dx1 = x2 - x1; dy1 = y2 - y1;
/* watch out for verticals! */
    if(dx1 != 0.)m1 = dy1/dx1; else l1vert = 1;
    b1 = y1 - m1*x1;
/* now check each wall of inner room for cut */
    for(i=0; i<NLs; i++){
	if(first){
	    l2vert[i] = 0;
	    lx1[i] = Lx[i]; 
	    ly1[i] = Ly[i];
	    lx2[i] = Lx[(i+1)%NLs]; 
	    ly2[i] = Ly[(i+1)%NLs]; 
/* get wall equations */
	    dx2[i] = lx2[i] - lx1[i]; 
	    dy2[i] = ly2[i] - ly1[i];
	    if(dx2[i] != 0.)m2[i] = dy2[i]/dx2[i]; else l2vert[i] = 1;
	    b2[i] = ly1[i] - m2[i]*lx1[i];
	    if(i==3)first = 0;
	}
/* both vertical */
	if(l1vert && l2vert[i]){
	    if(x1 != lx1[i])continue;
	    mn1 = SMIN(y1,y2); 
	    if(NOTSPKR(x1,mn1))
	     if(INRANGE(mn1,ly1[i],ly2[i]))
	      CUT;
	    mx1 = SMAX(y2,y1);
	    if(NOTSPKR(x1,mx1))
	     if(INRANGE(mx1,ly1[i],ly2[i]))
	      CUT;
	    continue;
	}
/* wall vertical */
	if(l2vert[i]){
	    ycutq = m1*lx1[i]+b1;
	    if(NOTSPKR(lx1[i],ycutq))
	     if(INRANGE(ycutq,ly1[i],ly2[i]))
	      if(INRANGE(lx1[i],x1,x2))
	       CUT;
	    continue;
	}
/* given line vertical */
	if(l1vert){
	    ycutq = m2[i]*x1+b2[i];
	    if(NOTSPKR(x1,ycutq))
	     if(INRANGE(ycutq,y1,y2))
	      if(INRANGE(x1,lx1[i],lx2[i]))
	       CUT;
	    continue;
	}
/* no verticals, calculate intercept point (cx,cy) */
	cx = (b2[i]-b1)/(m1-m2[i]); 
	cy = m1*cx + b1;
	if(NOTSPKR(cx,cy))
	 if(INRANGE(cx,x1,x2))
	  if(INRANGE(cx,lx2[i],lx1[i]))
	   if(INRANGE(cy,y1,y2))
	    if(INRANGE(cy,ly2[i],ly1[i]))
	     CUT;
    }
    NOCUT;
}
/*
 * getrefl calculates the reflection point (rx,ry) of a ray path from
 * source point (sx,sy) to surface s and back to channel output at (cx,cy)
 */
getrefl(sx,sy,cx,cy,s,rx,ry)
 double sx,sy,cx,cy,*rx,*ry; int s;
{
 double lx1,lx2,ly1,ly2,d2,s2,c2,r2,x,y,a;
 double dx1, dy1, dx2, dy2, m1, m2, b1, b2;
 static double d[]={0.,0.,0.,0.}, sint[4],cost[4],rho[4],sin2t[4],cos2t[4],
 f1[4], f2[4];

    s = s%NAs;
    lx1 = Ax[s];
    ly1 = Ay[s];
    lx2 = Ax[(s+1)%NAs];
    ly2 = Ay[(s+1)%NAs];
/*
 * find normal equations for walls (needs to be done only once)
 */
    if(d[s] == 0.){	
	d[s] = 1./sqrt( (lx2-lx1)*(lx2-lx1) + (ly2-ly1)*(ly2-ly1) );
	sint[s] = (ly2-ly1)*d[s];
	cost[s] = (lx2-lx1)*d[s];
	rho[s] = ly1*cost[s] - lx1*sint[s];
	if(rho[s]>0.){sint[s]= -sint[s]; cost[s]= -cost[s]; rho[s]= -rho[s]; }
	sin2t[s] = 2.*sint[s]*cost[s];
	cos2t[s] = 2.*cost[s]*cost[s] - 1.;
	f1[s] = -2.*rho[s]*sint[s];
	f2[s] =  2.*rho[s]*cost[s];
    }
/*
 * find phantom source location
 */
    x = f1[s] + sy*sin2t[s] + sx*cos2t[s];
    y = f2[s] - sy*cos2t[s] + sx*sin2t[s];
/*
 * calculate and return wall intercept of ray from phantom source to speaker
 */
    dx1 = x - cx; 
    if(dx1){ dy1 = y - cy; m1 = dy1/dx1; b1 = y - m1*x; }
    dx2 = lx2 - lx1;
    if(dx2){ dy2 = ly2 - ly1; m2 = dy2/dx2; b2 = ly1 - m2*lx1; }
    if(!dx2){ *ry = m1*lx1+b1; *rx = lx1; return; }
    if(!dx1){ *ry = m2*x+b2; *rx = cx; return; }
    *rx = (b2-b1)/(m1-m2); *ry = m1*(*rx) + b1; return;

/*
 * alternative method using normal equations (slower)
 */
/*
 *     d2 = 1./sqrt( (x-cx)*(x-cx) + (y-cy)*(y-cy) );
 *     s2 = (y-cy)*d2;
 *     c2 = (x-cx)*d2;
 *     r2 = y*c2 - x*s2;
 *     if(r2>0.){s2= -s2; c2= -c2; r2= -r2;}
 *     a = 1./(sint[s]*c2 - cost[s]*s2);
 *     dy1 = (r2*sint[s] - rho[s]*s2)*a;
 *     dx1 = (r2*cost[s] - rho[s]*c2)*a;
 */
}
/*
 * do_delay looks up a sample delayed by tau samples using interpolation
 * on a circular buffer of length len with present sample at buf[now]
 */
double do_delay(buf,len,now,tau) float buf[]; double tau; long len, now;{
 register long t1, t2;
    t1 = now + tau;
    while(t1 >= len)t1 -= len;
    t2 = t1 + 1;
    while(t2 >= len)t2 -= len;
    return(buf[t1] + (tau - floor(tau))*(buf[t2] - buf[t1]));
}
/*
 * fp3alloc allocates memory for a 3-D array, C-style
 */
double *** fp3alloc(x,y,z) register int x,y,z; {
 register double ***fp3; register int i,j;
    if ((fp3 = (double ***) calloc(x,sizeof(double **))) == NULL){
	fprintf(stderr,"\nCMUSIC: space generator: fp3alloc failed.\n");
	exit (-1);
    }
    for (i = 0; i < x; i++) {
	if ((fp3[i] = (double **) calloc(y, sizeof(double *))) == NULL){
	    fprintf(stderr,"\nCMUSIC: space generator: fp3alloc failed.\n");
	    exit (-1);
	}
	for (j = 0; j < y; j++) {
	    if ((fp3[i][j] = (double *) calloc(z, sizeof(double))) == NULL){
		fprintf(stderr,"\nCMUSIC: space generator: fp3alloc failed.\n");
		exit (-1);
	    }
	}
    }
    return(fp3);
}
/*
 * fp3free frees memory for a 3-D array, C-style
 */
fp3free(fp3,x,y,z) register double ***fp3; register int x,y,z; {
 register int i,j;
    for (i = 0; i < x; i++) {
	for (j = 0; j < y; j++) {
	    free(fp3[i][j]);
	}
	free(fp3[i]);
    }
    free(fp3);
}
