#define	EQUAL	1
#define	LESS	2
#define	GREATER	4
#define	VAR	int
#define SYMBOL	int


/*
 * PARTD c'est un element de la liste des symboles de la partie droite
 * d'une regle de derivation. Le champs symb contient la valeur du symbole
 * qui est un entier defini comme macro. C'est aussi la liste des symboles
 * qui sont en relation de precedence avec un autre symbole. Dans ce cas
 * le champs val contient le type de relation. val c'est un entier dont les
 * trois bits de faible poids indiquent si la relation (definie comme macro
 * plus haut) existe.
 */
typedef	struct	partie_droite {
	struct	partie_droite	*next;
	SYMBOL	symb;
	int	val;
}	PARTD;


/*
 * REGLE c'est un element de la liste des regles de derivation. Le champs
 * var contient la valeur de la variable (partie gauche d'une regle). 
 * C'est un entier defini comme macro. Le champs partd est un pointeur
 * vers la liste des symboles qui represantent la partie droite de la regle.
 */
typedef	struct	regle {
	struct	regle	*next;
	VAR	var;
	PARTD	*partd;
}	REGLE;


/*
 * PRECREL c'est un element d'une liste de relations de precedence. Le champs
 * symb est la valeur du symbole partie gauche d'une relation. partd c'est
 * un pointeur vers la liste des symbole qui chacun est la partie droite
 * d'une relation avec le symbole partie gauche. Pour trouver une relation
 * entre deux symbole il faut chercher d'abords le premier symbole dans la
 * liste formee avec PRECREL puis le deuxieme dans la liste pointee par partd.
 */
typedef	struct	precedence_rel {
	struct	precedence_rel	*next;
	SYMBOL	symb;
	PARTD	*partd;
}	PRECREL;
