#include <stdio.h>
#include "sndawk.lx.h"
#include "sndawk.h"

#ifdef CARL
#include <carl/carl.h>
#endif

/*
 * On execute la liste des fils du symbole
 */
#define EX for(symb2 = symb -> fils; symb2 != NULL; symb2 = symb2 -> frered) execute (symb2); return(1);

float	out;			/* out est la valeur qu'on doit sortir */
SYMB	*format;
extern	IOSAMPS	*isamps, *osamps;/* pointe vers l'echantillon d'entre(sortie)*/
extern	int	c_isprint,intty, otty;	/* indique si l'entre ou la sortie est un tty*/

extern double atof();
extern SVAR *cherchesvar();

SVAR *svar1, *svar2;

float samprate;
extern	float	eval();
execute (symb)
        SYMB * symb;
{
	SYMB * symb2;
	char ch[80];
	int i;
	DELAY *delay, *last;
	int ichans, ochans;
	int go_out = 0;
	FILE	*file;

    if(symb == NULL) return(1);

    switch (symb -> symbtype) {

	case VROOT: 
	    EX

	case VBEGIN: 
	    EX

	case VCORPS: 
/*
 * On commence par allouer de l'espace pour les lignes de retard
 */
	    svar1 = cherchesvar("SR");
	    samprate = svar1 -> valeur;

	    svar1 = cherchesvar("ID");
	    svar2 = cherchesvar("IC");
	    isamps -> delay = (int) svar1 -> valeur;
	    isamps -> chans = ichans = (int) svar2 -> valeur;

	    delay = last = ALLOC(isamps -> elem, DELAY)
	    delay -> chans = (float *) calloc(ichans, sizeof(float));

	    for(i = 0; i < svar1 -> valeur; i++){
		ALLOC(delay, DELAY)
		delay -> last = last;
		last -> next = delay;
		delay -> chans = (float *) calloc(ichans, sizeof(float));
		last = delay;
	    }
	    delay -> next = isamps -> elem;
	    isamps -> elem -> last = delay;

	    svar1 = cherchesvar("OD");
	    svar2 = cherchesvar("OC");
	    osamps -> delay = (int) svar1 -> valeur;
	    osamps -> chans = ochans = (int) svar2 -> valeur;

	    delay = last = ALLOC(osamps -> elem, DELAY)
	    delay -> chans = (float *) calloc(ochans, sizeof(float));

	    for(i = 0; i < svar1 -> valeur; i++){
		ALLOC(delay, DELAY)
		delay -> last = last;
		last -> next = delay;
		delay -> chans = (float *) calloc(ochans, sizeof(float));
		last = delay;
	    }
	    delay -> next = osamps -> elem;
	    osamps -> elem -> last = delay;

	    svar1 = cherchesvar("NS");
	    svar2 = cherchesvar("TM");

	    while(1) {
/*
 * On boucle tant qu'il y a des echantillons en entree
 */
		for(i=0; i<ichans; i++){
			if(intty){
				if(scanf("%s",ch)==EOF){
					go_out++;
					break;
				}
				*(isamps -> elem -> chans + i) =  atof (ch);
#ifdef DEBUG
				printf("%d\t%f\n",
					isamps -> elem -> chans + i,
					*(isamps -> elem -> chans + i));
#endif
			}
			else
#ifdef	CARL
				if(getfloat(isamps->elem->chans + i)==NULL){
#else
				if(read(0, isamps->elem->chans + i,
						sizeof(float))==NULL){
#endif
					go_out++;
					break;
				}
		}
		if (go_out) break;

		for(i=0; i<ochans; i++){
			*(osamps -> elem -> chans + i) = 0.;
		}

		for(symb2 = symb->fils; symb2 != NULL; symb2 = symb2 -> frered)
		    execute (symb2);
		if(!c_isprint)
		    for(i=0; i<ochans; i++){
			if(otty)
				printf("%f\n",*(osamps -> elem -> chans + i));
			else
#ifdef	CARL
				putfloat(osamps -> elem -> chans + i);
#else
				write(1, osamps -> elem -> chans + i,
								sizeof(float));
#endif
		    }
		isamps -> elem = isamps -> elem -> last;
		osamps -> elem = osamps -> elem -> last;

		svar1 -> valeur += 1.;
		svar2 -> valeur += 1./samprate;
	    }
	    return(1);

	case VEND: 
	    EX

	case VSTAT:
	    EX

	case VIF:
/*
 * Si l'evaluation du fils retourne vrai on execute le frered du fils
 * sinon el frered du frered du fils
 */
	    if(eval(symb ->fils)) execute(symb -> fils -> frered);
		else execute(symb -> fils -> frered ->frered);
	    return(1);

	case VWHILE:
/*
 * Tant que l'evaluation du fils retourne vrai on execute le frered du fils
 */
	    while(eval(symb ->fils)) execute(symb -> fils -> frered);
	    return(1);

	case VFOR:
/*
 *
 */
	    execute(symb -> fils);
	    while(eval(symb -> fils -> frered)) {
			execute(symb -> fils -> frered -> frered -> frered);
			execute(symb -> fils -> frered -> frered);
	    }
	    return(1);

	case LPRINT:
/*
 * On sort l'evaluation du fils
 */
	    if (symb -> frered -> symbtype == LFILE || 
					symb -> frered -> symbtype == LCOM)
	    	printlist(symb -> fils,symb -> frered -> lexval.file -> stream);
	    else
	    	printlist(symb -> fils, stdout);
	    return(1);

	case LPRINTF:
/*
 * On imprime avec le format du champ lexval du fils l'evaluation de son frered
 */
	    if (symb -> frered -> symbtype == LFILE || 
					symb -> frered -> symbtype == LCOM)
		file = symb -> frered -> lexval.file -> stream;
	    else
		file = stdout;
	    fprintf(file,symb -> fils -> lexval.string);
	    if (symb -> fils -> symbtype == LSTRING) {
		format = symb -> fils -> fils;
		printflist(symb -> fils -> frered,file);
	    }
	    return(1);

	case LPRINTERR:
	    fprintf(stderr,symb -> fils -> lexval.string);
	    if (symb -> fils -> symbtype == LSTRING) {
		format = symb -> fils -> fils;
		printflist(symb -> fils -> frered,stderr);
	    }
	    return(1);

	case LREAD:
	case LASGNOP:
	case LVIRGULE:
	case LPTINTER:
	case LOGOP:
	case LRELOP:
	case LARTOP1:
	case LARTOP2:
	case LARTOP3:
	case LFUNC:
	case LSVAR:
	case LVAR:
	case LNUM:
	case LISAMPS:
	case LOSAMPS:
	case LINCDEC:
	case LDECINC:
	case LPOSTOP:
	case LUNOP:
	    eval(symb);
	    return(1);
	case LFILE:
	case LCOM:
	    return(1);
	default:
	    printf ("execution error\n");
	    return (0);
    }
}


