#include <stdio.h>
#include "sndawk.lx.h"
#include "sndawk.h"
#include "gram.h"

extern	SYMB	*root;
/*
 * error c'est pour erreurs de relations de precedence (mis a 1 quand entre deux
 * symboles contigues il n'y a aucune relation) done est mis a 1 par la fonction
 * reduce() quand il y a eu reduction (sinon on n'a pas de regle a reduire).
 */
int	error, done;

analyse_syntaxique () {
    int     i, j, q, k;
    SYMB    *symb, *first, *last;

/*
 * On boucle jusqu'a ce qu'on a reduit tout ou on trouve une erreur
 */
    while (1) {


/*
 * On parcourt la liste a reduire commencant avec le deuxieme symbole (le
 * premier est le #) jusqu'au avant-dernier (le dernier est le #) ou jusqu'a
 * ce qu'on trouve entre le symbole courant et le suivant la relation >.
 * Si entre le symbole courant et le suivant il n'y a pas de relation
 * (error a 1) on sort de la boucle for puis de la boucle while.
 */
	for (last = root -> frered;
	    last -> frered != NULL &&
	    precedence(last -> symbtype * 128 + last -> frered -> symbtype) !=
									GREATER;
	    last = last -> frered)
		if (error) break;


/*
 * En cas d'erreur ou si on a reduit tous ce qu'on pouvait reduire on sort
 */
	if (error || (last -> symbtype == SHARP)) break;


/*
 * last pointe vers le dernier symbole de la suite qu'on doit reduire. On
 * essaye de faire pointer first trois symbole avant last sans depasser
 * le deuxieme symbole (frereg de root). i va indiquer combien de symboles
 * on a entre first et last
 */
	for (i = 0, first = last;
		first -> frereg != root && i < 3;
		first = first -> frereg, ++i);


/*
 * On essaye de reduire la suite de symboles entre first et last en approchant
 * first de last. On verifie si la relation entre le frereg de first et first
 * contient <. On calcule un entier qui va representer la suite en decalant
 * a gauche le premier symbole de trois fois sept bits le deuxieme deux fois
 * sept bits et ainsi de suite tant qu'on a des symboles entre first et last
 */
	for (done = 0; i >= 0; first = first -> frered, i--) {
	    if(precedence(first -> frereg -> symbtype * 128 + first -> symbtype)
									& LESS){
		for (   k = 0,
			q = 128 * 128 * 128,
			j = i,
			symb = first;
		    j >= 0;
		    k += q * symb -> symbtype,
			symb = symb -> frered,
			q /= 128, j--);


/*
 * Si on a reussi a reduire on sort de la boucle for
 */
		if (reduce (first, last, k))
		    break;
	    }
	}

/*
 * Si on est sorti de la boucle sans reduire on sort de la boucle while
 */
	if (!done) break;

#ifdef DEBUG
    prettyprint(root,0);
#endif
    }

/*
 * On est la parce qu'on a trouve deux symboles sans relations ou
 * on n'a pas pu reduire ?
 */
    if(error || !done){
    	fprintf(stderr,"syntax error in line %d\n",last -> frered -> line);
#ifdef DEBUG
	prettyprint(root,2);
	printf("error = %d\tdone = %d\n", error, done);
#endif
    	exit(-1);
    }


/*
 * Si on reussi a reduire les premiers trois symboles on a gagne.
 * Le premier et le dernier symbole sont # et sont les seuls #
 * le deuxieme doit etre VPROG.
 */
    if (root->frered->frered != NULL){
	first = root;
	last = root->frered->frered;
	if (reduce (first, last, first -> symbtype * 128 * 128 * 128 +
			first -> frered -> symbtype * 128 * 128 +
			last -> symbtype * 128)){
#ifdef DEBUG
    		prettyprint(root,0);
#endif
		return(1);
	}
    }


/*
 * On n'a pas reussi a reduire # VPROG #
 */
    fprintf(stderr,"syntax error in line %d\n",last->line);
#ifdef DEBUG
    prettyprint(root,2);
#endif
    exit(-1);
}
