# include <stdio.h>

#define NORM(x,y) ((float) (y) / (float) (x == SF_SHORT ? 32767.0 : 1.0))

# include <sys/types.h>
# include <sys/stat.h>
# include <sys/file.h>
# include <sfheader.h>

# define CONTINUE error++; continue


/* This program is designed to find the peak absolute value of an existing 
   soundfile and put it in the header */

float maxamp = 0.0;
long totalbytes, maxloc;
char	*getsfname();

main(argc,argv)
int argc;
char *argv[];
{
	int sfd,error = 0;
	struct stat st;
	char *name;
	SFMAXAMP *sfm, *getmaxamp();
	SFHEADER hd;
	int update,i;
	long sampframes;

	while(--argc) {
	    update = 1;
	    name=getsfname(*++argv);
	    if(!name){
		fprintf(stderr,"Can't get sfname for %s\n",*argv);
	    }
	    else{
		if((sfd = open(name,O_RDWR)) == -1) {
			if((sfd = open(name,O_RDONLY)) == -1) {
				fprintf(stderr,"Can't find soundfile %s\n",name);
				CONTINUE;
			}
			fprintf(stderr,"Can't update file %s - reading only!\n",name);
			update = 0;
		}

		if(rheader(sfd,&hd)) {
			fprintf(stderr,"Bad header read for %s\n",name);
			CONTINUE;
		}
		if(fstat(sfd,&st)) {
			fprintf(stderr,"Bad stat() for %s\n",name);
			CONTINUE;
		}

		sampframes = sfbsize(&st) / sfchans(&hd) / sfclass(&hd);

		if((sfm = getmaxamp(sfd,update,0,sampframes)) == NULL) {
			fprintf(stderr,"Bad return from getmaxamp\n");
			CONTINUE;
		}
		printf("Maxamp for file %s:\n",name);
		for(i = 0; i < sfchans(&hd); i++) {
			printf("channel %d = ",i + 1);
			if(sfmaxamp(sfm,i)) 
				
				printf("%f (absolute %f) at sample location %d\n",
					NORM(sfclass(&hd),sfmaxamp(sfm,i)),
					sfmaxamp(sfm,i),sfmaxamploc(sfm,i));
					
			else
				printf("silence\n");
		}
		close(sfd);
	    }
	}
	exit(error);
}
