#ifdef UNIXFILES
#include <sys/file.h>
#include <soundfile.h>
#endif

# define SETSAMP(x) if(cp == 'S') \
				(x).flags |= TIME_IN_SAMP
# define NOSTRUCT if(!new) { \
				notsetup(line_number); \
				break; \
			   }

short gdurplus;
short inputfiles;

# include <stdio.h>
# include "mixer.h"
# define MAXLINE 4096
# include <ctype.h>

char *getkey(line,args) register char *line,**args; {
	register char *cp = line;

	while(*cp && isspace(*cp)) cp++;
	if(*cp) 
		for(*args = cp; **args && !isspace(**args);(*args)++);  
	while(**args && isspace(**args)) (*args)++;
	return((*cp ? cp : NULL));
}
    				/* Initialize the send array */
init_CS(ptr) register struct C_SPECS *ptr; {
	register i;

	for(i = 0; i < MAXCHAN; i++)
		ptr->send[i][i] = 1.0; /* default */
}

	/* Procedure to setup the run queue for the mixer program */
setup() {
	register struct SOUND_FILE *new;
	char   *keyword,*argptr, line[MAXLINE], *getkey(), *getk();
	static short  line_number = 0;
	short first = 1;    
	char tmpname[256];
#ifdef UNIXFILES
	char *getsfname();
#endif UNIXFILES
	char *index();
	float lasttime = 0;
	char cp;
	char fake[MAXLINE];
	float tempval;

	queue = new = last = NULL;		/* init the pointers */

#define SETZVAL(lval,comval)  lval = ((comval)  ? (comval) : 0)
	/* Set values to zero unless they were on the command line   */

	SETZVAL(gdur.sft.s,cgdur.sft.s);
	SETZVAL(gskip.sft.s,cgskip.sft.s);
	SETZVAL(gdurplus,cgdurplus);
	inputfiles = 0;

	while(getk(line) != NULL) {		/* Till EOF */
	 line_number++;   
	 if((keyword = getkey(line,&argptr)) == NULL) continue; /* Blank line */
	 switch(key(keyword)) { /* switch on token */

		case KEYWORD: /* Illegal keyword */
		 errs.errnum = KEYWORD;
		 errs.arg.i = line_number;
		 errs.str = keyword;
		 mixerr();
		 break;

		case INPUT: /* input */
		 inputfiles++;
		 if(new)         /* if there is one waiting */
		  	install(new);       /* put on queue */
		  if((new = GETCORE(SOUND_FILE)) == NULL) 
			nomemory();
		  first = 1;
		  new->filed = -1;
		  new->ampfac = 1.0;
		  new->flags = PR;
		  sscanf(argptr,"%s",tmpname);
#ifdef UNIXFILES
		  strncpy(new->fname,getsfname(tmpname),sizeof(new->fname));
#else UNIXFILE
		  strncpy(new->fname,tmpname,sizeof(new->fname));
#endif UNIXFILES

		  break;

		case START: /* Start */
		 {
		 char c = *argptr;

		 NOSTRUCT
		 if(c == '+' || c == '-')
		 	sscanf(argptr+1,"%f%c",&(new->start.sft.s),&cp);
		 else
		 	sscanf(argptr,"%f%c",&(new->start.sft.s),&cp);

		 if(c == '+') 
			new->start.sft.s += lasttime;
		 else 
			if (c == '-') 
				new->start.sft.s = lasttime - new->start.sft.s;

		 lasttime = new->start.sft.s;
		 SETSAMP(new->start);
		 break;
		 }
		


		case DURATION: /* duration */
		 NOSTRUCT
		 sscanf(argptr,"%f%c",&(new->end.sft.s),&cp);
		 SETSAMP(new->end);
		 break;

		case GLDUR:  /* global duration */
		 {
		 	char c = *argptr;
		 	if(c == '+') {
		 		sscanf(argptr+1,"%f%c",&gdur.sft.s,&cp);
				gdurplus = 1;
		 	}
		 	else
		 		sscanf(argptr,"%f%c",&gdur.sft.s,&cp);
		 }
		 SETSAMP(gdur);
		 break;

		case SKIP:  /* skip */
		 NOSTRUCT
		 sscanf(argptr,"%f%c",&(new->offset.sft.s),&cp);
		 SETSAMP(new->offset);
		 break;

		case GLSKIP:  /* global skip */
		 sscanf(argptr,"%f%c",&gskip.sft.s,&cp);
		 SETSAMP(gskip);
		 break;

		case SRATE: /* srate */
		 sscanf(argptr,"%f",&srate);
		 break;

		case OUTPUT: /* output */
		 sscanf(argptr,"%s",tmpname);
#ifdef UNIXFILES
		 strcpy(outfile,getsfname(tmpname));
#else UNIXFILES
		 strcpy(outfile,tmpname);
#endif UNIXFILES
		 break;

		case AMPFAC: /* ampfac */
		 NOSTRUCT
		 sscanf(argptr,"%f",&(new->ampfac));
		 break;

		case OCHANS: /* ochans */
		 sscanf(argptr,"%d",&outchans);
		 if(outchans > MAXCHAN || outchans < 0 || outchans == 3) {
		  errs.str = "output file";
		  errs.errnum = ILLCHN;
		  mixerr();
		 }
		 break;

		case SEND: /* Send */
		 {
			int argcount,assign1,assign2;
			float amount;

			NOSTRUCT
			if(new->more == NULL) { /* Don't init the structure */
			 if((new->more =  GETCORE(C_SPECS)) == NULL) 
				nomemory();
			}
			if(first) { /* Only first time */
			 int i;

			/* If we give a send then the default channel assignment
			   is nullified. Now there are no channels getting sound
			   unless specifically asked for. */

			 first = 0; /* No more resets */
			 for(i = 0; i < MAXCHAN; i++) 
				new->more->send[i][i] = 0;
			}

			/* How many args? */

			argcount = sscanf(argptr,"%f%d%d",&amount,&assign1,&assign2);
			if(argcount < 2) { /* Bad input */
			 errs.errnum = NOINPUT;
			 errs.str = new->fname;
			 errs.arg.i = line_number;
			 mixerr();
			}

			if(argcount == 2) { /* Mono send */
			 if(assign1 < 1 || assign1 > MAXCHAN) {
			  errs.errnum = ILLCHN;
			  errs.str = new->fname;
			  errs.arg.i = line_number;
			  mixerr();
			 }
			new->more->send[0][assign1 - 1] = amount;
			}
			else { /* Two args stereo send */
			 if(assign1 < 1 || assign1 > MAXCHAN || assign2 < 1 
				|| assign2 > MAXCHAN) { /* error */
			  		errs.errnum = ILLCHN; 
			  		errs.str = new->fname;
			  		errs.arg.i = line_number;
			  		mixerr();
			 }
			 new->more->send[assign1 - 1][assign2 - 1] = amount;
			}
		 break;
		 }

		/* FIN and FOUT are now implemented via ENV */
		case FIN: /* fin */
		 NOSTRUCT
		 sscanf(argptr,"%f%c",&tempval,&cp);
		 if(tempval < 0) {
			 errs.errnum = SFFADE; 
			 errs.str = new->fname;
			 errs.arg.i = line_number;
			 mixerr();
		 }
		 if(tempval == 0) /* Will generate dup breakpoints */
			continue;

		 if(new->more == NULL) {
		  if((new->more =  GETCORE(C_SPECS)) == NULL) 
			nomemory();
		  init_CS(new->more);
		 }

		 if(cp != 'S')
			cp = ' ';

		 /* fake envelope input */
		 sprintf(fake,"0 0 1 %f%c",tempval,cp);
		 argptr = fake;
		 goto enventry;
		 break;

		case FOUT: /* Fout */
		 NOSTRUCT
		sscanf(argptr,"%f%c",&tempval,&cp);
		 if(tempval < 0) {
			 errs.errnum = SFFADE; 
			 errs.str = new->fname;
			 errs.arg.i = line_number;
			 mixerr();
		 }
		 if(tempval == 0) /* will generate dup breakpoints */
			continue;

		 if(new->more == NULL) {
		  if((new->more =  GETCORE(C_SPECS)) == NULL) 
			nomemory();
		  init_CS(new->more);
		 }
		 /* Do envelope */
		 if(cp != 'S')
			cp = ' ';

		 sprintf(fake,"1 -%f%c 0 end",tempval,cp);
		 argptr = fake;
		 goto enventry;
		break;

		case LOOP: /* Loop */
		 NOSTRUCT
		 new->flags |= LP;
		 break;

		case PRECISE: 
		 NOSTRUCT
		 new->flags |= PR; 
		 break;

		case NPRECISE: /* Turn off precise mode */
		 NOSTRUCT
		 new->flags &= ~PR;
		 break;

		case UNIT:
		 sscanf(argptr,"%d",&MIXUNIT);
		 if(MIXUNIT < 128 || MIXUNIT > 32*1024) {
			  errs.errnum = ILLUNIT; 
			  errs.arg.i = MIXUNIT;
			  mixerr();
		 	  MIXUNIT = DMIXUNIT; /* Back to default */
		 }
		 break;

#ifdef UNIXFILES
		case CDSF: /* Change sound file directory precise mode */
		 {
		 	char envtmp[1024],*setenv();

		 	sscanf(argptr,"%s",tmpname);
			sprintf(envtmp,"%s=%s",SFDIR,tmpname);
			setenv(envtmp);
		 }
		 break;
#endif
		case MIX:
		 if(new) {
		 	install(new);
		 	return(0);
		 }
		 else
			return(-1);
		 break;

		case FULL:
			full = 1;
		 break;

#define END "en"
		case ENV: /* Envelope  */
enventry:	 {
		 struct envptr *eptr;
		 short vals ;
		 char *tmp;
		 float envval,envloc;
		 char arg2[30];

		 NOSTRUCT
		 while((vals = sscanf(argptr,"%f%s",&envval, arg2)) > 1) {
		 	if(new->more == NULL) {
		  	if((new->more =  GETCORE(C_SPECS)) == NULL) 
				nomemory();
		  	init_CS(new->more);
		 	}
		 	/* Must sort later */
		 	if((eptr =  GETCORE(envptr)) == NULL) 
				nomemory();
		 	eptr->env_val = envval;

			/* Special word end? */
			if(strncmp(arg2,"en",2) == 0) {
				envloc = END_OF_FILE;
				cp = ' ';
			}
			else 
				sscanf(arg2,"%f%s",&envloc,&cp);

		 	eptr->env_start.sft.s = envloc;

			/* Skip two fields */
			getkey(argptr,&tmp);
			argptr = tmp;
			getkey(argptr,&tmp);
			argptr = tmp;

			 if(new->more->c_envptr) {
				new->more->c_envptr->env_next = eptr; /* Link in */
				eptr->env_pre = new->more->c_envptr;
			 }
			 else 
				new->more->h_envptr = eptr; /* Head node */
	
			 new->more->c_envptr = eptr;
			 SETSAMP(eptr->env_start);
			}
		 }
		 break;

		case COMMENT:
		 break;
	  } /* End of switch */
	 } /* End of if not the empty line */
	 if(new) {
	 	install(new);        /* last one waits for EOF */
	 	return(1);
	}
	else
		return(-1);
}

char *getk(s) char *s; {	/* just like gets but it also stops at ';' */
	register c;		/* N.B. - COMMENTS ARE NOW ONLY '<' !!!	   */
	register char *cs;

	cs = s;
	c = getchar();		/* read first char	*/
	if (c == '\n' || c < 0)
		goto done;
	if (c == '<') {		/* kluge to deal with comments containing ';' */
		*cs++ = c;
		while ((c = getchar()) != '\n')
			;
		goto done;
	}
	*cs++ = c;
	while ((c = getchar()) != '\n' && c >= 0 && c != ';')
	 	*cs++ = c;				 
done:	if (c < 0 && cs == s)
		return(NULL);
	*cs++ = '\0';
	return(s);
}

notsetup(line)
{
	
	errs.errnum = NOTSETUP; 
	errs.arg.i = line; 
	mixerr();
}
