# include <stdio.h>
# include "mixer.h"

qmixem(tail_queue,samples,cur_samp)


struct SOUND_FILE       *tail_queue;
long cur_samp,samples;
{

	/* Procedure to do the quick mode of mixing soundfiles. The files must
	   all have the same number of channels and only ampfac is allowed. All files
	   must have same class so that no conversion is done. */

	long samp_count;
	register sample_count;
	struct SOUND_FILE *ptr;
	int askfor;
	double mulfac;

	for(samp_count = samples; samp_count >0; samp_count -= MIXUNIT) {
		if(foutput) { /* Do floats in and out */
			register float *ofptr = outflt, *ifptr = inflt;

#ifdef vax
			bzero(outflt,MIXUNIT * FLOAT);
#else
			for(sample_count = MIXUNIT;sample_count;sample_count--)
				*ofptr++ = 0;
#endif
			askfor = samp_count < MIXUNIT ? samp_count : MIXUNIT;
			askfor *= FLOAT; /* In bytes */
			for(ptr = queue; ptr != tail_queue->right_activate; 
				ptr = ptr->right_activate) {
#ifdef UNIXFILES
				 if(ptr->filed < 0)
					sfopn(ptr,MUSTHAVE);
#endif

				 if((sample_count = sfread(ptr->filed,inflt,askfor)) == -1) {
	fprintf(stderr,"fd = %d, inflt = %X, askfor = %d\n",ptr->filed,(int) inflt,askfor);
					errs.errnum = SFREAD;
					errs.str = ptr->fname;
					mixerr();
				 }

				 while(sample_count < askfor && ptr->flags & LP)  {
					int more,ret;

					/* Rewind */
					if(sflseek(ptr->filed,ptr->offset.sft.l * ptr->class,0) == -1) {
						errs.str = ptr->fname;
						errs.errnum = SKIP;
						mixerr();
					}
					/* Get remaining samples */
					more = askfor - sample_count;
					if((ret = sfread(ptr->filed,((char *)
						inflt)+sample_count,more)) == -1) {
						errs.errnum = SFREAD;
						errs.str = ptr->fname;
						mixerr();
					}
					sample_count += ret;
				}
				sample_count /= FLOAT;
				ofptr = outflt;
				ifptr = inflt;
				if(ptr->ampfac != 1)
					for(;sample_count;sample_count--) 
						*ofptr++ += *ifptr++ * ptr->ampfac;
				else /* No ampfac */
				for(;sample_count;sample_count--) 
					*ofptr++ += *ifptr;
#ifdef UNIXFILES
				if(openfiles > MAXOPEN)
					sfcls(ptr,KEEP);
#endif
	
			}
			if(sfwrite(outfd,outflt,askfor) != askfor) {
				errs.errnum = SFWRITE;
				mixerr();
			}
		}
		else { /* Do short in and short out */
			register short *optr = outint, *iptr = inint;

#ifdef vax
			bzero(outint,MIXUNIT * INT);
#else
			for(sample_count = MIXUNIT;sample_count;sample_count--)
				*optr++ = 0;
#endif
			askfor = samp_count < MIXUNIT ? samp_count : MIXUNIT;
			askfor *= INT;
			for(ptr = queue; ptr != tail_queue->right_activate; 
				ptr = ptr->right_activate) {
#ifdef UNIXFILES
				 if(ptr->filed < 0)
					sfopn(ptr,MUSTHAVE);
#endif
				 if((sample_count = sfread(ptr->filed,inint,askfor)) == -1) {
					errs.errnum = SFREAD;
					errs.str = ptr->fname;
					mixerr();
				 }

				 while(sample_count < askfor && ptr->flags & LP)  {
					int more,ret;

					/* Rewind */
					if(sflseek(ptr->filed,ptr->offset.sft.l * ptr->class,0) == -1) {
						errs.str = ptr->fname;
						errs.errnum = SKIP;
						mixerr();
					}
					/* Get remaining samples */
					more = askfor - sample_count;
					if((ret = sfread(ptr->filed,((char *)
						inint)+sample_count,more)) == -1) {
						errs.errnum = SFREAD;
						errs.str = ptr->fname;
						mixerr();
					}
					sample_count += ret;
				}
				sample_count /= INT;
				optr = outint;
				iptr = inint;
				if(ptr->ampfac != 1) 
					for(mulfac = ptr->ampfac;sample_count;sample_count--)  
					 *optr++ += (int) ((float) *iptr++ * mulfac);
				else /* No ampfac */
					for(;sample_count;sample_count--)  
					 *optr++ += *iptr++;
#ifdef UNIXFILES
				if(openfiles > MAXOPEN)
					sfcls(ptr,KEEP);
#endif
			 }
			if(sfwrite(outfd,outint,askfor) != askfor) {
				errs.errnum = SFWRITE;
				mixerr();
			}
		}
	}
}
