# include <stdio.h>
# include "mixer.h"
# include <sys/stat.h>

check()
{
	/* Procedure to check out all parameters of the mix queue before mixing */

	register struct  SOUND_FILE  *ptr;
	struct stat statst;

#ifdef UNIXFILES
	int fd;
	SFHEADER header;
#else
	struct SFDESC sfdesc;
	short *cylptr;
#endif UNIXFILES

	for(ptr= queue; ptr; ptr = ptr->right_activate) {
		errs.str = ptr->fname;         /* assume we need name */

#ifdef UNIXFILES
		if((fd = open(ptr->fname,READ)) < 0) {  /* file not there */
			errs.errnum = NOFILE;
			mixerr();
		}
		if(rheader(fd,&header)) {
			errs.errnum = BADHEADER; /* NOHEADER */
			mixerr();
		}
		if(fstat(fd,&statst)) {  /* file not there */
			errs.errnum = NOFILE;
			mixerr();
		}
#else
		if(sfstat(ptr->fname,&sfdesc,&statst,&cylptr)) { 
			errs.errnum = NOFILE;
			mixerr();
		}
#endif UNIXFILES


#ifdef UNIXFILES
		if((SFCLASS != SF_SHORT && SFCLASS != SF_FLOAT)) {
#else
		if((SFCLASS != INT && SFCLASS != FLOAT) || sfdesc.sf_type != SAMPLES) {
#endif
			errs.errnum = SFTYPE;
			mixerr();
		}

		/* BAD "Bad ampfac"
		if(ptr->ampfac <= 0) {  /* Bad ampfac */ /*
			errs.errnum = AMPFAC;
			errs.arg.f = ptr->ampfac;
			mixerr();
		}
		*/

		if(SFSRATE !=  srate) { /* Not a matching sampling rate */
			errs.errnum = BADSRATE;
			errs.arg.f = SFSRATE;
			mixerr();
		}

		/* Check if file is to short */

		if(!(ptr->flags & LP))   /* Check only if no loop. */
			if(ptr->offset.sft.l + ((float) (ptr->end.sft.l - ptr->start.sft.l)
				* ((float) ptr->chans / (float) outchans)) > 
			    (SFBSIZE / (long) SFCLASS )) {
				errs.errnum = SHORTFILE;
				errs.arg.f = (float)((SFBSIZE / SFCLASS)
				    / (float) SFCHANS / srate);
				mixerr();
			}

		if(outchans != SFCHANS) { 
			if(ptr->more) { /* Must have specified a send */
				int in,out;
				for (in = 0; in < MAXCHAN; in++)
					for (out = 0; out < MAXCHAN; out++)
						if(ptr->more->send[in][out])
							goto good;
			}
			errs.errnum = MIXEDMODE;
			errs.arg.i = SFCHANS;
			mixerr();
		}
		if(ptr->more && ptr->more->h_envptr) { /* Envelope */
			struct envptr *eptr = ptr->more->h_envptr;

			while(eptr) {
				if(eptr->env_next)
					if(eptr->env_start.sft.l == eptr->env_next->env_start.sft.l &&
						eptr->env_val != eptr->env_next->env_val) {
						errs.errnum = BADENV;
						errs.arg.f = (float) eptr->env_start.sft.l / (float) (srate * outchans);
						mixerr();
					}
					eptr = eptr->env_next;
			}


		}
			
good:
#ifdef UNIXFILES
	close(fd);
#endif UNIXFILES
	}
}                

