h63330
s 00001/00001/00051
d D 1.9 85/09/04 21:46:45 robert 9 8
c Working with CCSS.
e
s 00002/00002/00050
d D 1.8 85/08/27 21:39:10 robert 8 7
c Version with input for samples.
e
s 00027/00001/00025
d D 1.7 85/06/28 21:45:15 robert 7 6
c Version for unlimited number of input UNIX files.
e
s 00004/00003/00022
d D 1.6 85/06/25 20:28:48 robert 6 5
c Formatted for better printing. Works with sfname() for SFPATH.
e
s 00004/00005/00021
d D 1.5 85/06/25 12:02:45 robert 5 4
c 4.2 working version for UNIX files.
e
s 00003/00001/00023
d D 1.4 84/05/16 15:09:13 robert 4 3
c Working (I think) version for exact mixing.
e
s 00001/00007/00023
d D 1.3 84/05/11 20:15:16 robert 3 2
c Don't use RAW mode as who knows what read and write are.
e
s 00002/00002/00028
d D 1.2 84/05/11 16:54:04 robert 2 1
c First version of exact sample mixing. Robert
e
s 00030/00000/00000
d D 1.1 82/12/08 08:38:06 robert 1 0
c date and time created 82/12/08 08:38:06 by robert
e
u
U
t
T
I 1
# include "mixer.h"
# include <stdio.h>

I 7
#ifdef UNIXFILES
sfopn(ptr,flag)
	register struct SOUND_FILE *ptr;
{

	if(flag & CANWAIT)
		fprintf(stderr,"Opening file %s (time = %.4f%s)\n",
D 8
			ptr->fname,(float) (ptr->start.l ) / (float) (srate * 
E 8
I 8
			ptr->fname,(float) (ptr->start.sft.l ) / (float) (srate * 
E 8
			(long) outchans),ptr->flags & PR ? "" : " precise mode off");

	if((flag & MUSTHAVE) || (openfiles + 1 <= MAXOPEN)) { 
		if((ptr->filed = sfopen(ptr->fname,READ)) == -1) {
			errs.errnum = NOFDS;
			errs.str = ptr->fname;
			mixerr();
		}
	
		if(sflseek(ptr->filed,(long) ptr->loc ,0) == -1) {
				errs.str = ptr->fname;
				errs.errnum = SKIP;
		}
		openfiles++;
	}
}
#else

E 7
sfopn()
{

	/* Open a soundfile for the Eastamn mixer program */
D 3
	/* To use raw mode: If the type is INT then input channels can't be less then
	   output channels. If FLOAT type then input channels * 2 can't be less than
	   output channels. */
E 3

D 3
	int mode;
E 3

D 3
	mode = (endptr->class == INT ? endptr->chans : endptr->chans * 2) < outchans ? READ : RAWSF(READ);

	if((endptr->filed = sfopen(endptr->fname,mode)) == -1) {
E 3
I 3
	if((endptr->filed = sfopen(endptr->fname,READ)) == -1) {
E 3
		errs.errnum = NOFDS;
		errs.str = endptr->fname;
		mixerr();
	}

D 5
	if(endptr->offset.l > 0L)
D 2
		if(sflseek(endptr->filed,(long) endptr->offset.l * (long) MIXUNIT * (long) endptr->class,0) == -1) {
E 2
I 2
		if(sflseek(endptr->filed,(long) endptr->offset.l  * (long) endptr->class,0) == -1) {
E 2
			errs.str = endptr->fname;
			errs.errnum = SKIP;
		}
E 5
I 5
D 6
	if(sflseek(endptr->filed,(long) endptr->offset.l  * (long) endptr->class,0) == -1) {
		errs.str = endptr->fname;
		errs.errnum = SKIP;
E 6
I 6
D 9
	if(sflseek(endptr->filed,(long) endptr->offset.l  * 
E 9
I 9
	if(sflseek(endptr->filed,(long) endptr->offset.sft.l  * 
E 9
		(long) endptr->class,0) == -1) {
			errs.str = endptr->fname;
			errs.errnum = SKIP;
E 6
	}
E 5
D 2
	fprintf(stderr,"Opening file %s (time = %f)\n",endptr->fname,(float) (endptr->start.l * (long) MIXUNIT) / (float) (srate * (long) outchans));
E 2
I 2
D 4
	fprintf(stderr,"Opening file %s (time = %f)\n",endptr->fname,(float) (endptr->start.l ) / (float) (srate * (long) outchans));
E 4
I 4
	fprintf(stderr,"Opening file %s (time = %.4f%s)\n",
D 8
	endptr->fname,(float) (endptr->start.l ) / (float) (srate * 
E 8
I 8
	endptr->fname,(float) (endptr->start.sft.l ) / (float) (srate * 
E 8
	(long) outchans),endptr->flags & PR ? "" : " precise mode off");
E 4
E 2
}

D 7

E 7
I 7
#endif
E 7
E 1
