h09052
s 00030/00042/00084
d D 1.15 86/10/06 13:55:25 timis 17 14
c Fixed the "absurd ampfac". In fact negative ampfacs are very usefull
e
s 00002/00000/00112
d R 1.11.1.1 86/10/06 13:33:04 timis 16 11
c Fixed bed ampfac. negative ampfacs are usefull
e
s 00000/00000/00126
d R 1.15 86/10/06 13:14:30 timis 15 14
c 
e
s 00008/00002/00118
d D 1.14 86/07/21 16:23:45 yocom 14 13
c if dur specified is too long and send or env, problem...
e
s 00004/00002/00116
d D 1.13 86/07/04 18:00:48 robert 13 12
c yocom followup: setting up default channel assignments
e
s 00034/00028/00084
d D 1.12 86/07/03 16:59:28 yocom 12 11
c yocom edition: new defaults for channel assignments
e
s 00001/00001/00111
d D 1.11 85/12/06 23:16:44 robert 11 10
c Output sampling rate is now set from the first member of the run queue.
e
s 00017/00005/00095
d D 1.10 85/10/22 14:30:38 robert 10 9
c Diags for envelope mistakes.
e
s 00003/00005/00097
d D 1.9 85/09/03 09:44:35 robert 9 8
c Compare fadein + fadeout by detecting cross over no end and start times.
e
s 00001/00001/00101
d D 1.8 85/09/02 20:28:24 robert 8 7
c Added 'full' keyword.
e
s 00002/00002/00100
d D 1.7 85/08/27 21:39:17 robert 7 6
c Version with input for samples.
e
s 00012/00005/00090
d D 1.6 85/07/05 00:29:22 robert 6 5
c Correct check for short file length.
e
s 00005/00004/00090
d D 1.5 85/06/25 20:28:54 robert 5 4
c Formatted for better printing. Works with sfname() for SFPATH.
e
s 00041/00012/00053
d D 1.4 85/06/25 12:02:50 robert 4 3
c 4.2 working version for UNIX files.
e
s 00000/00000/00065
d D 1.3 84/05/16 15:09:19 robert 3 2
c Working (I think) version for exact mixing.
e
s 00003/00003/00062
d D 1.2 84/05/11 16:54:10 robert 2 1
c First version of exact sample mixing. Robert
e
s 00065/00000/00000
d D 1.1 82/12/08 08:37:26 robert 1 0
c date and time created 82/12/08 08:37:26 by robert
e
u
U
t
T
I 1
# include <stdio.h>
# include "mixer.h"
# include <sys/stat.h>

I 13
D 17
static char *sccs_id =   "%W%	%G%";

E 17
E 13
check()
{
D 12
	/* Procedure to check out all parameters of the mix queue before mixing */
E 12
I 12
D 17
	/* Procedure to check all parameters of the mix queue before mixing */
E 17
I 17
	/* Procedure to check out all parameters of the mix queue before mixing */
E 17
E 12

	register struct  SOUND_FILE  *ptr;
D 4
	struct stat stat;
E 4
I 4
	struct stat statst;

#ifdef UNIXFILES
	int fd;
	SFHEADER header;
#else
E 4
	struct SFDESC sfdesc;
	short *cylptr;
I 4
#endif UNIXFILES
E 4

	for(ptr= queue; ptr; ptr = ptr->right_activate) {
		errs.str = ptr->fname;         /* assume we need name */

D 4
		if(sfstat(ptr->fname,&sfdesc,&stat,&cylptr)) {  /* file not there */
E 4
I 4
#ifdef UNIXFILES
		if((fd = open(ptr->fname,READ)) < 0) {  /* file not there */
E 4
			errs.errnum = NOFILE;
			mixerr();
		}
I 4
		if(rheader(fd,&header)) {
			errs.errnum = BADHEADER; /* NOHEADER */
			mixerr();
		}
		if(fstat(fd,&statst)) {  /* file not there */
			errs.errnum = NOFILE;
			mixerr();
		}
#else
D 5
		if(sfstat(ptr->fname,&sfdesc,&statst,&cylptr)) {  /* file not there */
E 5
I 5
		if(sfstat(ptr->fname,&sfdesc,&statst,&cylptr)) { 
E 5
			errs.errnum = NOFILE;
			mixerr();
		}
#endif UNIXFILES
E 4


D 4
		if((sfdesc.sf_class != INT && sfdesc.sf_class != FLOAT) || sfdesc.sf_type != SAMPLES) {
E 4
I 4
#ifdef UNIXFILES
		if((SFCLASS != SF_SHORT && SFCLASS != SF_FLOAT)) {
#else
		if((SFCLASS != INT && SFCLASS != FLOAT) || sfdesc.sf_type != SAMPLES) {
#endif
E 4
			errs.errnum = SFTYPE;
			mixerr();
		}

D 17
		if(ptr->ampfac <= 0) {  /* Bad ampfac */
E 17
I 17
		/* BAD "Bad ampfac"
		if(ptr->ampfac <= 0) {  /* Bad ampfac */ /*
E 17
			errs.errnum = AMPFAC;
			errs.arg.f = ptr->ampfac;
			mixerr();
		}
I 17
		*/
E 17

D 4
		if(sfdesc.sf_srate !=  srate) { /* Not a matching sampling rate */
E 4
I 4
		if(SFSRATE !=  srate) { /* Not a matching sampling rate */
E 4
D 11
			errs.errnum = SRATE;
E 11
I 11
			errs.errnum = BADSRATE;
E 11
D 4
			errs.arg.f = sfdesc.sf_srate;
E 4
I 4
			errs.arg.f = SFSRATE;
E 4
			mixerr();
		}

D 9
		/* Check if file is to short but don't forget about mono -> stereo */
E 9
I 9
D 12
		/* Check if file is to short */
E 12
I 12
D 17
		/* Check if file is too short */
E 17
I 17
		/* Check if file is to short */
E 17
E 12
E 9

D 2
		if(!(ptr->flags & LP))   /* Check only if no loop. Allow 2 MIXUNITS error for block adjustments */
			if((ptr->offset.l + (ptr->end.l - ptr->start.l) - 2) > 
E 2
I 2
		if(!(ptr->flags & LP))   /* Check only if no loop. */
D 6
			if((ptr->offset.l + (ptr->end.l - ptr->start.l)) > 
E 2
D 4
			    (sfdesc.sf_bsize / (long) sfdesc.sf_class * (long) 
D 2
			    (outchans / sfdesc.sf_chans ) / MIXUNIT)) {
E 2
I 2
			    (outchans / sfdesc.sf_chans ))) {
E 4
I 4
			    (SFBSIZE / (long) SFCLASS * (long) 
			    (outchans / SFCHANS ))) {
E 6
I 6
D 7
			if(ptr->offset.l + ((float) (ptr->end.l - ptr->start.l)
E 7
I 7
D 8
			if(ptr->offset.l + ((float) (ptr->end.sft.l - ptr->start.sft.l)
E 8
I 8
D 12
			if(ptr->offset.sft.l + ((float) (ptr->end.sft.l - ptr->start.sft.l)
E 8
E 7
				* ((float) ptr->chans / (float) outchans)) > 
			    (SFBSIZE / (long) SFCLASS )) {
E 12
I 12
D 17
			if(ptr->offset.sft.l +
			   ((float) (ptr->end.sft.l - ptr->start.sft.l)
			   * ((float) ptr->chans / (float) outchans)) > 
			   (SFBSIZE / (long) SFCLASS )) {
E 17
I 17
			if(ptr->offset.sft.l + ((float) (ptr->end.sft.l - ptr->start.sft.l)
				* ((float) ptr->chans / (float) outchans)) > 
			    (SFBSIZE / (long) SFCLASS )) {
E 17
E 12
E 6
E 4
E 2
				errs.errnum = SHORTFILE;
D 4
				errs.arg.f = (float)((sfdesc.sf_bsize / sfdesc.sf_class)
				    / (float) sfdesc.sf_chans / srate);
E 4
I 4
				errs.arg.f = (float)((SFBSIZE / SFCLASS)
D 12
				    / (float) SFCHANS / srate);
E 12
I 12
D 17
				    	     / (float) SFCHANS / srate);
E 17
I 17
				    / (float) SFCHANS / srate);
E 17
E 12
E 4
				mixerr();
			}
D 12

D 4
		if(ptr->more == NULL && outchans != sfdesc.sf_chans) { /* No send */
E 4
I 4
D 6
		if(ptr->more == NULL && outchans != SFCHANS) { /* No send */
E 6
I 6
		if(outchans != SFCHANS) { 
			if(ptr->more) { /* Must have specified a send */
				int in,out;
				for (in = 0; in < MAXCHAN; in++)
					for (out = 0; out < MAXCHAN; out++)
						if(ptr->more->send[in][out])
							goto good;
E 12
I 12
D 14
  
D 13
  		if(outchans != SFCHANS) {   /* check if SEND was given */
E 13
I 13
  		if(outchans != SFCHANS || outflag) { /*SEND must be given*/
E 14
I 14
D 17
  		if(outchans != SFCHANS) { /* SEND must be given */
 
E 14
E 13
  			int in,out;
  			if(ptr->more) { 
D 13
  				for (in = 0; in < MAXCHAN; in++)
E 13
I 13
  				for (in = 0; in < SFCHANS; in++)
E 13
  					for (out = 0; out < MAXCHAN; out++)
  						if(ptr->more->send[in][out])
  							goto ckenv;
I 14
				/*
				 * if no send was given, assign default send
				 */
				for(in = 0; in < SFCHANS; in++)	
					ptr->more->send[in][in] = 1;
E 14
  			}
E 17
I 14

E 14
D 17
			else if(ptr->more == NULL) {    
				if((ptr->more = GETCORE(C_SPECS)) == NULL)
					nomemory();
				for(in = 0; in < SFCHANS; in++)	
					ptr->more->send[in][in] = 1;
E 17
I 17
		if(outchans != SFCHANS) { 
			if(ptr->more) { /* Must have specified a send */
				int in,out;
				for (in = 0; in < MAXCHAN; in++)
					for (out = 0; out < MAXCHAN; out++)
						if(ptr->more->send[in][out])
							goto good;
E 17
E 12
			}
E 6
E 4
D 12
			errs.errnum = MIXEDMODE;
D 4
			errs.arg.i = sfdesc.sf_chans;
E 4
I 4
			errs.arg.i = SFCHANS;
E 4
			mixerr();
		}
D 6

E 6
I 6
D 10
good:
E 6
D 9
		if(ptr->more) /* Check for too lng a fadin or a fadout */
D 4
			if((ptr->more->fndur + ptr->more->ftdur) > (ptr->end.l - ptr->start.l)) { /* Fadin + Fadout exceed dur */
E 4
I 4
			if((ptr->more->fndur + ptr->more->ftdur) > 
D 5
				(ptr->end.l - ptr->start.l)) { /* Fadin + Fadout exceed dur */
E 4
				errs.errnum = FADELONG;
				mixerr();
E 5
I 5
D 7
				(ptr->end.l - ptr->start.l)) { 
E 7
I 7
				(ptr->end.sft.l - ptr->start.sft.l)) { 
E 7
					/* Fadin + Fadout exceed dur */
E 9
I 9
		if(ptr->more) /* Check for overlapped fadin/fadout */
			if(ptr->more->fn.sft.l > ptr->more->ft.sft.l) {
E 9
					errs.errnum = FADELONG;
					mixerr();
E 10
I 10
		if(ptr->more && ptr->more->h_envptr) { /* Envelope */
E 12
I 12
D 17
  		}
/* Envelope check */
ckenv:		if(ptr->more && ptr->more->h_envptr) {     
E 17
I 17
			errs.errnum = MIXEDMODE;
			errs.arg.i = SFCHANS;
			mixerr();
		}
		if(ptr->more && ptr->more->h_envptr) { /* Envelope */
E 17
E 12
			struct envptr *eptr = ptr->more->h_envptr;

			while(eptr) {
				if(eptr->env_next)
D 12
					if(eptr->env_start.sft.l == eptr->env_next->env_start.sft.l &&
						eptr->env_val != eptr->env_next->env_val) {
						errs.errnum = BADENV;
						errs.arg.f = (float) eptr->env_start.sft.l / (float) (srate * outchans);
						mixerr();
E 12
I 12
D 17
			 	    if((eptr->env_start.sft.l == 
					ptr->env_next->env_start.sft.l)
					&& (eptr->env_val
					!= eptr->env_next->env_val)) {
					      errs.errnum = BADENV;
					      errs.arg.f = 
					         (float) eptr->env_start.sft.l 
						 / (float) (srate * outchans);
					      mixerr();
E 17
I 17
					if(eptr->env_start.sft.l == eptr->env_next->env_start.sft.l &&
						eptr->env_val != eptr->env_next->env_val) {
						errs.errnum = BADENV;
						errs.arg.f = (float) eptr->env_start.sft.l / (float) (srate * outchans);
						mixerr();
E 17
E 12
					}
					eptr = eptr->env_next;
E 10
E 5
			}
I 17


E 17
I 10
D 12


E 12
		}
I 17
			
good:
E 17
D 12
			
good:
E 12
E 10
I 4
#ifdef UNIXFILES
	close(fd);
I 12
D 17

E 17
E 12
#endif UNIXFILES
E 4
	}
}                

E 1
