/*

Denis Lorrain, Mai 1986.

Compile with ...

CFLAGS = -DUNIXFILES -O
sndgain:	sndgain.o

*/

# include <stdio.h>
# include <math.h>
# include <sys/types.h>
# include <sys/stat.h>
# include <sys/file.h>
# include <sfheader.h>
# include <carl/sndio.h>

# define FAUX {fprintf(stderr,"Usage: sndgain [-I or -iN] In-sound Out-sound < Function\n");\
		exit(1);}
# define HEADSIZE 1024
# define MAXSHORT 65535.0
# define EPSILON 0.000001

# define FLUSH	nbytesO = (frame * nchans * SF_SHORT) % SF_BUFSIZE ;\
		if(write(sfd2,shortout,nbytesO) != nbytesO) {\
		fprintf(stderr,"Bad write to output file.\n");\
		close(sfd2);\
		close(sfd);\
		exit(1);\
		}
# define STOPERROR	close(sfd2);\
			close(sfd);\
			exit(1);

char	argscan();
extern char	*args_option;
extern char	**args_vector;

extern int	args_count;
main(argc,argv)
int argc;
char *argv[];
{
	struct stat st;
	SFHEADER hd, hd2;
	char ch;
	char newname[HEADSIZE];
	char amplitude[60];
	char *cp, *cp2, *getsfname();

	int sfd, error = 0, sfd2;
	int	num,
		nchans,
		numO = 0,
		nsampsO,
		nbytesO,
		numI = 0,
		nsampsI = 0,
		nbytesI,
		option = 0 /* Default: no flag given by user */
		;
	short *malloc(), *shortin, *shortout;
	long frame = 0, frame1, frame2, totinframes;
	double	ampli,
		ampli1,
		time1,
		ff1,
		ampli2,
		time2,
		ff2;
	double srate;
	double slopeampli;
	double	baze = 4.0 /* default value for exponential coefficient */,
		bzz;
	register double	n,
			dne,
			i,
			in;

	short	*sh;
	int	intmult,
		result;
	sh = (short *) &result;
	sh++;

/* Check parameters */
	while ((ch = argscan(argc,argv,"Ii|","")) != NULL) {
	switch (ch) {
		case 'i':
			option = 1;
			if (args_option != NULL) baze = atof(args_option);
			if(baze <= 0.0) {
			fprintf(stderr,"Interpolating factor must be >= 0\n");
			exit(1);
			}
			break;
		case 'I':
			option = 1;
			baze = 4.0;
			break;
		default :
			FAUX;
			}
	}
	if(args_count != 2) FAUX;
	if(!strcmp(args_vector[0],args_vector[1])) FAUX;	


/* Open In-sound file */
	cp = getsfname(args_vector[0]);
	readopensf(cp,sfd,hd,st,"sndgain",num);
	if(num == -1) {
		close(sfd);
		exit(1);
	}
	
	if(sfclass(&hd) != SF_SHORT) {
		fprintf(stderr,"In-sound (%s) must be packed in short samples.\n",cp);
		close(sfd);
		exit(1);
	}

	nchans = sfchans(&hd);
	srate = sfsrate(&hd);
	totinframes = ((sfbsize(&st) / SF_SHORT) /nchans) -1 ;

/* Open Out-sound file */
	strcpy(newname,args_vector[1]);
	if((sfd2 = open(getsfname(newname),O_CREAT|O_TRUNC|O_WRONLY,0644))<0) {	
	      fprintf(stderr,"Can't create soundfile %s\n",getsfname(newname));
		close(sfd);
		exit(1);
	}
	hd2 = hd;
	if(wheader(sfd2,&hd2)) {
		fprintf(stderr,"Failed to write new header.\n");
		STOPERROR
	}
	nsampsO = SF_BUFSIZE / SF_SHORT;

/* Allocate buffers */
	if(((shortin = malloc(SF_BUFSIZE)) == NULL) || 
		((shortout = malloc(SF_BUFSIZE)) == NULL)) {
		fprintf(stderr,"Bad call to malloc.\n");
		STOPERROR
	}

/* Read first ampli-time pair */
	scanf("%s%f",amplitude, &time1);
	ampli1 = sfexpr(amplitude,1.0);
	if (ampli1 < 0.0) {
		fprintf(stderr,"First amplitude < 0.0\n");
		STOPERROR
	}
	if (ampli1 == 0.0) ampli1 = EPSILON;
	if (time1 != 0.0) {
		fprintf(stderr,"First time point != 0\n");
		STOPERROR
	}
	frame1 = (time1 + EPSILON) * srate;

/* (( 1 )) Read ampli-time pairs loop */
					/*option=0 : quick interpolation */
					/*option=0 : quick interpolation */
if (option == 0) {
while (scanf("%s%f",amplitude, &time2) != EOF){
	ampli2 = sfexpr(amplitude,1.0);
	if (ampli2 < 0.0) {
		fprintf(stderr,"Amplitude < 0.0 at %f sec. of Function\n",time2);
		STOPERROR
	}
	if (ampli2 == 0.0) ampli2 = EPSILON;
	frame2 = (time2 + EPSILON) * srate;
	if (frame2 <= frame1) {
		fprintf(stderr,"Non-increasing time points at %f sec. of Function\n",time2);
		FLUSH
		STOPERROR
	}
	ff1 = (double) frame1;
	ff2 = (double) frame2;
	slopeampli = pow((ampli2 / ampli1) , (1.0 / (ff2 - ff1)));
	ampli = ampli1;

/* (( 2 )) Read samples loop, inside a segments of ampli function */
	for(frame=frame1; frame<frame2; frame++){
	if(numI == nsampsI){
		nbytesI=read(sfd,shortin,SF_BUFSIZE);
		nsampsI = nbytesI / SF_SHORT ;
		if(nsampsI <= 0){
		fprintf(stderr,"Bad read from input file.\n");
		FLUSH
		STOPERROR
		}
		numI = 0;
	}

	if(numO == nsampsO){
		if(write(sfd2,shortout,SF_BUFSIZE) != SF_BUFSIZE){
		fprintf(stderr,"Bad write to output file.\n");
		STOPERROR
		}
		numO = 0;
	}

	intmult = (int) (floor((ampli * MAXSHORT)+0.5));
	for(num=0; num<nchans; num++){
		result = shortin[numI] * intmult ;
		shortout[numO] = *sh ;
		numI++;
		numO++;
	}

	if(frame == totinframes) {
		frame++;
		FLUSH
		close(sfd2);
		close(sfd);
		fprintf(stderr,"End of In-sound.\n");
		exit(error);
	}

	ampli *= slopeampli;
	}
	

	frame1 = frame2;
	ampli1 = ampli2;
	time1 = time2;
}
}

else {
					/*option=1 : slow interpolation */
					/*option=1 : slow interpolation */
while (scanf("%s%f",amplitude, &time2) != EOF){
	ampli2 = sfexpr(amplitude,1.0);
	if (ampli2 < 0.0) {
		fprintf(stderr,"Amplitude < 0.0 at %f sec. of Function\n",time2);
		STOPERROR
	}
	if (ampli2 == 0.0) ampli2 = EPSILON;
	frame2 = (time2 + EPSILON) * srate;
	if (frame2 <= frame1) {
		fprintf(stderr,"Non-increasing time points at %f sec. of Function\n",time2);
		FLUSH
		STOPERROR
	}
	ff1 = (double) frame1;
	ff2 = (double) frame2;
	if (ampli2 < ampli1) bzz = -baze;
	else bzz = baze;
	dne = (ampli2 - ampli1) / (1.0 - exp(bzz));
	n = bzz / ((ff2 - ff1) - 1.0);
	i = 0.0;

/* (( 2 )) Read samples loop, inside a segments of ampli function */
	for(frame=frame1; frame<frame2; frame++){
	if(numI == nsampsI){
		nbytesI=read(sfd,shortin,SF_BUFSIZE);
		nsampsI = nbytesI / SF_SHORT ;
		if(nsampsI <= 0){
		fprintf(stderr,"Bad read from input file.\n");
		FLUSH
		STOPERROR
		}
		numI = 0;
	}

	if(numO == nsampsO){
		if(write(sfd2,shortout,SF_BUFSIZE) != SF_BUFSIZE){
		fprintf(stderr,"Bad write to output file.\n");
		STOPERROR
		}
		numO = 0;
	}

	in = i * n;
	ampli = ampli1 + (dne * (1.0 - exp(in)));
	intmult = (int) (floor((ampli * MAXSHORT)+0.5));
	i++;
	for(num=0; num<nchans; num++){
		result = shortin[numI] * intmult ;
		shortout[numO] = *sh ;
		numI++;
		numO++;
	}

	if(frame == totinframes) {
		frame++;
		FLUSH
		close(sfd2);
		close(sfd);
		fprintf(stderr,"End of In-sound.\n");
		exit(error);
	}

	}
	

	frame1 = frame2;
	ampli1 = ampli2;
	time1 = time2;
}
}

	FLUSH
	close(sfd2);
	close(sfd);
	fprintf(stderr,"End of ampli-time function.\n");
	exit(error);
}
