#include <stdio.h>
#include <sgtty.h>
#include "ediseg.h"

static struct sgttyb tty;

setcbi()
{
	if (gtty(0, &tty) < 0)
		perror("gtty");
	tty.sg_flags |= CBREAK;
	if (stty(0, &tty) < 0)
		perror("stty");
	}

clrcbi()
{
	tty.sg_flags &= ~CBREAK;
	if (stty(0, &tty) < 0)
		perror("stty");
	}

static char state = '!';

char playcmd(b, e, inc, timefac, end)
	float *b, *e, *inc; float timefac, end;
{
	char c, sav;
	float getf(), tmp;

	printf("I ");
	while (c = getchar())
		{
		switch (c) {
			case '!': return(c);
			case 'w': state = '!'; break;
			case 'i': sav = state;
			case 'b':
			case 'e': state = c; break;
			case '>':
			case '<': 
				if (state == 'b') *b += (c=='>')?*inc:-*inc;
				if (state == 'e') *e += (c=='>')?*inc:-*inc;
				if (state == '!') {
					*b += (c=='>')?*inc:-*inc;
					*e += (c=='>')?*inc:-*inc;
					}
				return(state);
			case '=':
				tmp = getf(end, timefac)/timefac;
				if (state == 'b') *b = tmp;
				if (state == 'e') *e = tmp;
				if (state == 'i') *inc = tmp;
				printf("%c = %f\n", state, tmp);
				if (state == 'i') state = sav;
				break;
			case EXIT:  return(c);
			case '?':
			case 'h': pchelp(); break;
			default : printf(" ?\n"); state = '!'; break;
			}
		}
	return('\0');
	}

float getf(end, timefac)
	float end, timefac;
{
	char buf[BUFSIZ];
	float f, sfexpr();

	clrcbi();
	fgets(buf, BUFSIZ, stdin);
	if (*buf == LAST) f = end;
	else f = sfexpr(buf, timefac);
	setcbi();
	return(f);
	}

pchelp()
{
printf("\n%s%s%s%s%s%s%s%s",
"Fast Interactive Mode Commands:\n",
"'x'\t\tto quit fast interactive mode\n",
"!\t\tplays current window\n",
"b or e\t\tsubsequent cmds move only begin or end time\n",
"> or <\t\tmove forewards/backwards by increment and play\n",
"w\t\tsubsequent commands move window\n",
"b=N or e=N\t set begin or end time to N\n",
"i=N\t\tset increment to N\n"
);
}

/*
 * main()
 * {
 * 	char c;
 * 	float beg, end, inc = 1.0;
 * 	setcbi();
 * 
 * 	while ((c = playcmd(&beg, &end, &inc)) != '\n')
 * 		{
 * 		printf("%c\tb=%f\te=%f\ti=%f\n", c, beg, end, inc);
 * 		if (end < beg) { printf("error: b must be > e\n"); continue; }
 * 		if ((end - beg) < MINDUR) 
 * 			{ printf("error: e - b must be > %f sec.\n", MINDUR); 
 * 			  continue; }
 * 		}
 * 
 * 	clrcbi();
 * 	}
 */
