include(/usr/`include'/carl/config.m4)dnl

C = m4CONVERTERS

CONV_PROGS = ${C}play ${C}monitor ${C}record ${C}reset

PROGS = catsf\
	createsf\
	fromsf\
	gainsf\
	lsf\
	mixsf\
	normsf\
	pansf\
	peaksf\
	querysf\
	retrosf\
	setsf\
	sndawk\
	swabsf\
	tarsf\
	tosf\
	transpsf\
	xdrin\
	xdrout


LIBS =		libbicsf
INCL =		`include'
ALIASES =	aliases
DOC =		doc
ORDER =  	.makefiles .includefiles .libraries .aliases .progs

# broken or obsolete
#	mountsf
#	scalesf
#	sndset

doit:	${ORDER} README

.makefiles:
	for file in ${ALIASES} ${INCL} ${LIBS} ${PROGS} ${CONV_PROGS} ${DOC}; \
	do \
		cd $${file} ; m4 Makefile.m4 > Makefile ; cd .. ; \
	done
	date > .makefiles

.includefiles:
	cd ${INCL} ; make ${MFLAGS};
	date > .includefiles

.libraries:
	for file in ${LIBS} ; \
	do \
		cd $${file} ; make ${MFLAGS}; cd .. ; \
	done
	date > .libraries

.aliases:
	cd ${ALIASES} ; make ${MFLAGS} install
	date > .aliases

.progs:
	- for file in ${PROGS} ${CONV_PROGS}; \
	do \
		cd $${file} ; make ${MFLAGS}; cd .. ; \
	done
	date > .progs

README: ./doc/Install.ms
	nroff -ms ./doc/Install.ms > README

install: .${ALIASES}
	for file in ${PROGS} ${CONV_PROGS}; \
	do \
		cd $${file} ; make ${MFLAGS} install ; cd .. ; \
	done



clean:	init mainclean cleanmakefiles

init:; rm -f ${ORDER}

mainclean:
	for file in ${PROGS} ${CONV_PROGS} ${LIBS} ${ALIASES} ${INCL} ; \
	do \
		cd $${file} ; make ${MFLAGS} clean ; cd .. ; \
	done

cleanmakefiles:; for file in */Makefile; do rm $${file}; done

cleanprogs:
	for file in ${PROGS} ${CONV_PROGS} ; \
	do \
		cd $${file} ; make ${MFLAGS} clean ; cd .. ; \
	done

doc: Install man
Install:; psroff -ms doc/Install.ms
man: man1 man3 man7
man1:; for file in */*.1; do psroff -man $${file}; done
man3:; for file in */*.3; do psroff -man $${file}; done
man7:; for file in */*.7; do psroff -man $${file}; done
