/* Waveform display for Visual 550 (Tek 4010) terminal */
/* cc -O disp.c -lv550 -lfrm -lm -o disp */
#include <stdio.h>
#include <math.h>
#include <carl/frm.h>

#define XMIN 0
#define XMAX 767
#define YMIN 0
#define YMAX 584
#define NWINDOW 8
#define INCR 4
#define WPEAK .25
#define USAGE\
{\
fprintf(stderr, "\nDISP Usage (Visual 550 only):\n");\
fprintf(stderr, " disp\n");\
fprintf(stderr, "	[\n");\
fprintf(stderr, "	-Wwindows_per_screen (8)\n");\
fprintf(stderr, "	-Rsample_rate (48K)\n");\
fprintf(stderr, "	-Tlabel_start_time (0)\n");\
fprintf(stderr, "	-L[Ss]time_in (s)\n");\
fprintf(stderr, "	-Idisplay_every_I-th_sample (4)\n");\
fprintf(stderr, "	-Pwindow_peak_range (.25)\n");\
fprintf(stderr, "	-An_samples_averaged_per_display_point (1)\n");\
fprintf(stderr, "	]\n");\
fprintf(stderr, "		< floatsams\n");\
exit(-1);\
}

double rate = 48.*1024.;

/* current screen coordinates */
double sxmin= 0., sxmax= 1., 
      symin= (double) NWINDOW, symax= 0.;
/* locate current window within screen coordinates */
double wxmin= 0.1, wxmax= 1.,
      wymin= 0., wymax= 1.;
/* current plot range coordinates */
double rxmin= 0., rxmax= 512., 
      rymin= (WPEAK), rymax= -(WPEAK);

main(argc, argv) int argc; char *argv[];
{
 double x, sum, input;
 double nwindow = (double) NWINDOW;
 double t = 0., starttime = 0.;
 double lastdx, lastdi, tick = .001;
 int scount, average = 1, incr = INCR, samps = 0;
 char s[100];
 int i, n;

    if(isatty(0))USAGE;
    for(i = 1; i < argc; i++){
	if(*argv[i] != '-')USAGE;
	switch(*(++argv[i])){
	    case 'W': symin = nwindow = expr(++argv[i]); break;
	    case 'R': rate = expr(++argv[i]); break;
	    case 'T': starttime = expr(++argv[i]); break;
	    case 'I': incr = expr(++argv[i]); break;
	    case 'L': if(*(++argv[i]) == 'S')samps = 1; break;
	    case 'P': rymin = expr(++argv[i]); rymax = -rymin; break;
	    case 'A': average = expr(++argv[i]); break;
	}
    }
    openpl();
    erase();
    x = 0.0;
    n = 0;
    windowbox();
    move(wx(0.),wy(0.));
    sprintf(s,"P=%.3f",rymax);
    label(s);
    move(wx(0.),wy(0.5));
    t = starttime+n/rate;
    sprintf(s,"%.3f",t);
    if(samps)sprintf(s,"%d", (int) (starttime*rate+n));
    label(s);
    move(px(0.0), py(0.0));
    lastdx = px(0.0);
    lastdi = py(0.0);
    while(getfloat( &input) ){
	sum = input;
	scount = 1;
	while(scount < average){
	    getfloat( &input);
	    sum += input;
	    scount++;
	}
	input = sum/scount;
	n += scount;
	t = starttime+n/rate;
	if( ((int) x) % incr == 0){
	    cont(px(x), py(input));
	    lastdx = x; lastdi = input;
	}
	if( t/tick - floor(t/tick) < .5*rate*tick*tick){
	    /*
	    line(px(x),wy(wymin),px(x),wy(wymax));
	    */
	    line(px(x),wy(wymin),px(x),wy(wymin+.1*(wymax-wymin)));
	    line(px(x),wy(wymax),px(x),wy(wymax-.1*(wymax-wymin)));
	    move(px(lastdx), py(lastdi));
	}
	x += 1.;
	if(x < 512.) continue;
	x = 0.0;
	wymin += 1.;
	wymax += 1.;
	if(wymax > nwindow){ 
	    wymin = 0.; wymax = 1.; erase();
	    move(wx(0.),wy(0.));
	    sprintf(s,"P=%.3f",rymax);
	    label(s);
	}
	windowbox();
	move(wx(0.),wy(wymin+.5));
	sprintf(s,"%.3f",t);
	if(samps)sprintf(s,"%d", (int) (starttime*rate+n));
	label(s);
	move(px(x),py(input));
    }
    move(wx(wxmin),wy(wymax));
    closepl();
}
windowbox(){
    move(wx(wxmin),wy(wymin));
    cont(wx(wxmax),wy(wymin));
    cont(wx(wxmax),wy(wymax));
    cont(wx(wxmin),wy(wymax));
    cont(wx(wxmin),wy(wymin));
}

double interp(x, xmin, xmax, omin, omax) double x, xmin, xmax, omin, omax; {
    return( (x - xmin)*(omax - omin)/(xmax - xmin) + omin );
}
sx(x) double x; { /* screen to absolute */
 double interp();
    return( (int) interp(x, sxmin, sxmax, (double) XMIN, (double) XMAX) );
}
sy(y) double y; { /* screen to absolute */
    return( (int) interp(y, symin, symax, (double) YMIN, (double) YMAX) );
}
wx(x) double x; { /* window to absolute */
    return( sx(interp(x, wxmin, wxmax, wxmin, wxmax) ) );
}
wy(y) double y; { /* window to absolute */
    return( sy(interp(y, wymin, wymax, wymin, wymax) ) );
}
px(x) double x; { /* ranged data to absolute with window within screen */
 double interp();
    return( sx( interp(x, rxmin, rxmax, wxmin, wxmax) ) );
}
py(y) double y; { /* ranged data to absolute with window within screen */
 double interp();
    return( sy( interp(y, rymin, rymax, wymin, wymax) ) );
}
