.de Eb
.sp -1
.nf
\h'-.5n'\L'|\\nPu-1'\l'\\n(.lu+1n\(ul'\L'-|\\nPu+1'\l'|0u-.5n\(ul' \" draw box
.fi
..
.nr PO 1i
.po 1i
.nr LL 6.5i
.ll 6.5i
.ds CF
.hy 14
.EQ
delim $$
.EN
.TL
Introduction to the csound File System
.AU
D. Gareth Loy
.AI
Computer Audio Research Laboratory
Center for Music Experiment, Q-037
University of California, San Diego
La Jolla, California  92093
.AB 
At least three distinct problems must be addressed in order
to record, store, manipulate and play back high quality digital sound samples. 
The problems are 1) the sheer volume of data involved, 2) the high speed
at which the data must travel and 3) the bookkeeping involved in managing
the sound's vital statistics.  Each of these problems goes beyond
what can be handled conveniently by the regular 
.UX
file system, 
so a special file system just for sound has been constructed,
called the 
.B csound
file system.
This document covers most of
what is needed to get started using it. 
.AE
.RT
.bp 1
.NH 1
In General
.PP
The 
.B csound
file system has many points of similarity to the regular 
.UX
file system.
They both are used to store and retrieve information from 
mass storage systems such as disks.  But where the UNIX file system
is suitable for storing most things, the
.B csound
file system has been developed to cover its weaknesses in sound sample
storage.  In many cases, the names of commands which manipulate
.B csound
files are synonyms to their UNIX counterparts.
Where UNIX has an 
.B ls 
command to list the files in a directory, the 
.B csound
file system has an 
.B lsf 
command (``list sound files'').  Where UNIX has a 
.B mv
command to move files, the 
.B csound
file system has a 
.B mvsf.  
Similarly the UNIX 
.B cp
command, which copies files, has a counterpart named 
.B cpsf 
in 
.B csound. 
Lastly, the UNIX 
.B mkdir 
program (``make a directory'') becomes 
.B mksfdir.
.PP
From here the resemblance begins to fade.  Whereas UNIX allows you a variety of
ways to create new files, 
.B csound
has but two: 
.B sndout 
and 
.B record.
The 
.B record 
program creates a new sound file by reading the Analog to Digital
Converters (ADC) and storing the samples in a sound file.  
.B sndout
reads its standard input as the source of sound samples to be stored
on the sound file system.  
.PP
Similarly, there are two ways to get sound back from the
.B csound
file system: 
.B sndin 
and 
.B play.
.B play 
writes samples from the 
.B csound 
file system
to the Digital to Analog Converters (DAC),
which allow a
sound to be heard.  
.B sndin 
reads sound samples from the 
.B csound
file system and writes
them on its standard output. 
You can keep your sense of direction as to what ``in'' and ``out'' mean for
.B sndin
and
.B sndout
by remembering that the direction of transfer is always
.I
with respect to yourself.
.R
That is,
.B sndout
sends your samples
.I out
to the 
.B csound
file system,
.B sndin
reads them back
.I in.
.NH 1
Sndout
.PP
.B sndout 
reads its standard input and writes what it finds
there to a file on the 
.B csound
file system.
In order to demonstrate 
.B sndout 
we must first have a program that writes
samples for 
.B sndout 
to read.
For example, at CARL there is a program called 
.B wave 
which produces a 1 second sine waveform, (sampled
at 16KHz; sampling rates will be discussed further
below).
.B wave
writes sound samples on its 
standard output suitable for input to 
.B sndout.  
We can pipe this output to 
.B sndout 
like this:
.DS
% wave | sndout waveform
.DE
This action causes the samples to be fed from 
.B wave 
to 
.B sndout, 
which sends
them to the 
.B csound
file system
to be stored in a file called 
.I waveform.  
To be explicit, samples 
will be saved in a file whose full name 
is 
.I /some_filesystem/your_login_name/waveform
where 
.I some_filesystem
is the name of a 
.B csound
filesystem.  For example, at CARL, there are currently three possibilities,
for this, snda, sndb and sndc.
You need only remember the 
.I waveform 
part when you
are dealing with files you yourself have written.
More on this subject later.
.PP
Now that the sound is stored in a file on the 
.B csound
file system
we can play it by saying:
.DS
% play waveform
.DE
.PP
(Note: 
.B play 
will only work for files stored on the 
.B csound
file system.  
It will 
.I not 
work
for files on the UNIX file system).
.PP
Let us say that after hearing the sound we 
decided 
to rescale its amplitude.
A program to do this is called
.B gain.  
We would
use 
.B sndin 
to read the samples from the file
.I waveform,
then pipe them to 
.B gain.
Lastly, we pipe it back to the 
.B csound
file system to be saved.
.DS
% sndin waveform | gain .7 | sndout wave1
.DE
A couple of observations: 
.B gain
has one argument which is
a coefficient (in this case .7) with which to scale the signal on
its standard input.
Also, note that in writing out the file with 
.B sndout, 
we created a new file, 
.I wave1, 
instead
of simply writing back to 
.I waveform.  
In general, 
.I
it is not possible to both
read and write the same sound file at the same time.  
.R
While this is not strictly true under all circumstances, it is for the
ones being described here.  What would happen, if for instance we gave
the command
.DS
% sndin foo | sndout foo
.DE
is that 
.B sndout
would create a new file
.I foo
before 
.B sndin
had a chance to read up the old one.  The net result would be that the contents
of the file would be lost.
.PP
If we really wanted this scaled-down version of the file to be called 
.I waveform,
then we could use the command
.B mvsf 
to ``move'' the sound to a file of a different name, e.g.:
.DS
% mvsf wave1 waveform
.DE
.NH 1
Sound File Allocation
.PP
Former releases of this software utilized a
.I
fixed contiguous block 
.R
scheme of storage allocation which required knowing
in advance of writing a sound file how much storage space would be
required for it.  It has been modified to use a
.I
variable noncontiguous block
.R
scheme which alleviates this requirement almost entirely.  This
means it is no longer necessary to specify sizes or durations, space
is simply claimed as needed.  One program,
.B record,
still uses the contiguous block method for reasons of efficiency.
.NH 1
About Samples
.PP
Sound is stored digitally as a stream of numbers called 
.I samples.
Sound samples represent the instantaneous values of an
acoustic waveform somewhat in
the same fashion that successive frames of a moving picture store 
visual motion. 
.NH 2
Sample Representation
.PP
There are three representations of samples:
.IP *
binary short integer (called
.I shortsams),
.IP *
binary floating point, (called
.I floatsams),
and
.IP *
Arabic (you were expecting, perhaps,
.I jetsams?).
.LP
.I Shortsam
format is required by the DAC and ADC converters.
It is in this format that samples are (usually) stored on the 
.B csound
file system.  
.I Floatsam 
format
is capable of a much wider dynamic range
than 
.I shortsam, 
and is (usually) 
used by all CARL programs whenever programs pass samples between themselves
via the standard input/output.  
.I Arabic
is human-readable format, presented whenever 
a program notices that its standard output is connected to
a terminal.  Some programs refer to Arabic format as 
.I ASCII,*
which simply means ``in text format, suitable for printing on a screen''.
.FS
* ASCII stands for American Standard Code for Information Exchange.
.FE
.PP
.I Shortsams
are 16-bit, two's complement, which means they have
a range of integer values from \-32768 to +32767.  The DACs convert these
numbers to voltages between roughly \-10 and +10 volts.  Each 16-bit sample
occupies two 8-bit bytes on the disk.  
.I Floatsams
have a very wide dynamic
range ($+-$1.701411733192644270e38 on a VAX).
However, only values in the 
.I 
signed unit interval
.R
(that is, values in the interval [\-1,+1])
are (ordinarily) used to represent sound sample data.
Floatsams are 32 bits, and occupy 4 bytes.
All CARL 
programs which must convert from shortsam to floatsam sample formats
equate floatsam \-1.0 with shortsam \-32767 and floatsam +1.0
with shortsam +32767.  (Note that the value \-32768 is not ordinarily used).
.PP
As already mentioned, samples are stored on disk as shortsams.
But since 
.B sndout,
reads its standard input for samples, it must therefore be reading
floating point samples.  Thus, one of the actions of 
.B sndout
is to convert from floating point to integer before storing samples on the 
disk.  Obversely, 
.B sndin
must first convert shortsams to floatsams.
.PP
Programs can tell whether their standard input/output is connected to
a terminal or a file or pipe.  All CARL and
.B csound
programs which write sample data via their standard output first
determine whether the output is a terminal.  If so, the samples are 
printed in Arabic
format suitable for display on a terminal, otherwise they are written as
floatsams.
.NH 2
Sample Frames
.PP
A 
.I
sample frame 
.R
is taken to mean one sample for each channel.  
For mono files, each sample is a sample frame.
In Multi-channel
files, the channels are stored in sample interleaved order.  
For instance, in a 4-channel file 
the individual samples are stored:
.DS
A,B,C,D, A,B,C,D, A,B,C,D, ...
.DE
The sample index 
.I i,  
which corresponds to a particular time in seconds
.I T,
and channel
.I a, 
at sampling rate
.I R,
is given by 
.EQ
i ~=~ T * R * N + a
.EN
where
.I N
is the number of channels in a sample frame.
The time corresponding to a particular sample frame index is
.EQ
T ~=~ i over {R * N}
.EN
.PP
The number of channels is not limited by the
.B csound
file system.
However, there is a limit placed on the number of channels that can
be converted by the DACs and ADCs.  The current limits at CARL are
four channels of DAC and 2 channels of ADC.
.NH 2
Calculating Length of Files
.PP
Length of sound files in the
.B csound
file system
is measured in units of 
.I cylinders.
A
.I cylinder
is a large unit of storage on a disk, comprising roughly 300k to 400k
bytes on disks used at CARL.
Knowing the byte size
of a sample and how many there are per second allows us to calculate
the storage requirements of sound files of different duration.  For
instance, if we take a typical sample rate of 16384 samples per second,
one second of mono shortsams requires 
.EQ
{2 ~ bytes} over {sample} * {16384 ~ samples} over {second} ~=~ 32768i ~ bytes.
.EN
The actual cylinder size of one of the CARL disks (CDC 9766, mounted
as /snd1) is 311296 bytes.
Thus, a cylinder
can store 311296/32768 = 9.5 seconds worth of shortsams at that
sampling rate.  
The space requirement for stereo is exactly double that for mono, and
for N channels, is N times the mono length.
.NH 2
Sample Rates
.PP
The 
.I 
sample rate
.R
is the number of sample frames sent to (or fetched from)
the converters per second.
It is possible to record a sound with the
.B record
program at nearly any sampling rate, from about 50 samples per second
(sps)
up to a maximum of 49152 sps*, often written as 48K**.
.FS
*Sampling rates may be different at different sites.  At IRCAM
for instance, the sampling rate is 48000 samples per second.
.FE
.FS
**The notation 48K is to be read as $48 * 1024 ~=~ 49152$.
At IRCAM, one could say 48k, which is $48 * 1000$.
.FE
At CARL, two sample rates are typically used, 
48K sps for high-quality sound and 16K sps for tests and speech.
If, as shown above 9.5 seconds can be stored at 16K sps,
the amount of sound that can be stored on a cylinder at 48K sps
goes down to 3.166... seconds. 
But the frequency range that
can be represented goes up by a factor of three.  
For the 48K sps rate, the
frequency response goes from 0Hz up to nearly 20KHz, 
which covers the range of
human hearing pretty well.  For the 16KHz rate, the frequency
range is from 0Hz
up to 6.5KHz.  
.PP
There is obviously a tradeoff of 
sound quality vs. storage space needed.  Since the sound file storage space
is finite, and since one can get 3 times as much sound sampled
at the lower rate to fit on a disk, 
there is a strong impetus to work most
of the time at the slower sampling rate.  Not only do files written at
the 16 K sps sampling rate occupy smaller space, they also can be computed
three times as fast.  So here is a good rule of thumb: use the slow rate
for tests or sketches, and the faster rate for final products.
.PP
The sampling rate is analogous to the speed a tape recorder
runs when recording a sound.  Once recorded at some rate, playing
back the sound at any other
sampling rate merely changes the pitch and duration, not the sound quality
nor the storage requirements.  So the only places the sampling rate can be
set is where sound files are created: 
.I record 
and 
.I sndout.  
For both programs, you
supply a flag specifying the sampling rate you want.  For instance:
.DS
% wave | sndout \-R48K foo
.DE
will create sound file foo with the fast sampling rate.*
.FS
*
.B csound
programs understand 48K to mean 49152 by interpreting the 'K' as a
.I postoperator.  
See below.
.FE
If you do not specify the sampling rate, you get the default 16K sps rate.
.NH 1
Arithmetic Expressions In Flags
.PP
You may use arithmetic expressions in calculating numeric
values written after flags.  For instance, these three commands are
equivalent:
.DS
% sndout \-R49152
% sndout \-R48K
% sndout \-R"3*2^14"
.DE
In the second example, the 
.B K 
is a postoperator, 
which acts as a multiplier
.I 
times 1024.  
.R
Other postoperators include 
.B k
which multiplies by 1000.
Also,
using the exponentiation operator, 3*2^14 = 49152.  
The binary operators 
.B +,
.B \-,
.B *,
and
.B /,
as well as 
.B ()
are also available.*  
.FS
* Care must be exersized
when using the binary operator
.B *
(for multiplication) and parenthesis.
The UNIX shell will try to interpret them as part of
a regular expression, and search for a matching file,
usually with unsuccessful results which abort the command.
It is necessary to enclose expressions with 
.B *
and
.B ()
in them in quote marks (") to avoid this.
.FE
Other postoperators which are available are 
.B S, 
for samples, 
.B s 
for
seconds, 
.B ms 
for milliseconds, and 
.B m 
for minutes.
These are useful for retrieving parts of a sound file, described next.
.NH 1
Sndin
.PP
.B sndin 
can
read flags in addition to a file name
to determine its operation.
We'll focus here on begin time and an end time flags.
For instance:
.DS
% sndin \-b1 \-e1.1 test
.DE
reads file test between times 1 and 1.1 seconds.  That is, it starts
with the 16384th sample (assuming the sampling rate is 16K), 
and writes out 1638 samples.  
If you say nothing, or
if you simply supply the name of a file (as in our examples above), 
these times default to the beginning and end of the file.
We could have
asked it to calculate time in samples instead of seconds by using the
.B S
postoperator. 
For instance, to look at
the first 200 sample frames*, regardless of sampling rate, we would say
.DS
% sndin \-b0 \-e200S
.DE
.FS
*Note we said sample frames: if the file being read were stereo, we would
read out 400 actual samples, two from each frame.
.FE
Postoperators are also cumulative; we could have said 200KS to read in the
first 200*1024 samples.
.PP
It is often more convenient to specify a begin time and duration rather
than a begin time and end time.  To this end, the \-b and \-d flags
behave as you would expect:
.DS
% sndin \-b3 \-d64S
.DE
reads starting at three seconds, and goes for 64 samples. 
.NH 1
Lsf - Listing Sound Files
.PP
The
.B lsf
command,
if given by itself,
lists all the files in your current 
.B csound
directory.
It is possible to get a list of someone else's files simply by adding their
name as an argument, preceded by a slash:
.DS
% lsf /frm
.DE
lists the names of frm's files.  If you are interested in only whether a
particular file exists, just name it:
.DS
% lsf /frm/joy
.DE
.NH 1
Manual Pages For Sound Programs
.PP
There is more information about a sound file than
its name, which you can see by providing flags to 
.B lsf
to modify its behavior.
You can find out about these other flags and more about 
.B lsf 
itself, 
as well as all the rest of
the programs discussed here, by reading their entries
in the CARL section of the
Unix Programmer's Manual.
These manual pages give all the gory details too numerous
to cover here.  The manual exists in two forms: hardcopy and on-line,
that is, in pressed wood pulp and
on the computer.  To read the on-line manual entry for 
.B lsf 
say:
.DS
% man lsf
.DE
The 
.B man 
command shows you a screenful at a time from the manual.
After a full page of text is displayed on the screen it prints ``-more-''
at the bottom of the screen and waits for
you to press the spacebar before showing the next screenful.  
If you would like to see all the sound file programs about
which there are manual page entries, try another command:
.DS
% apropos csound
.DE
This will give you a list (it goes on for more than one screenful; ask
someone to show you how to make it slow down) of
all the sound programs in the manual.  Each has its own manual entry
available with the 
.B man 
command.
.NH 1
Cpsf - Copy Sound Files
.PP
This is a very simple program, similar to 
.B mvsf.  
But where 
.B mvsf 
simply
changes the name of a sound file, 
.B cpsf 
physically copies the samples into another file. 
For example,
.DS
% cpsf source destination
.DE
where 
.I source 
is the name of the file to be copied, 
.I destination 
is where
to put it.
.NH 1
Directories, and Filename Defaults
.PP
Just as the UNIX file system has a tree-structured directory, so does
.B csound.  
When you log in, unless you change it, you will be set up to access 
.B csound
files in your
.I home
.B csound
directory.
Your home directory may vary with the installation, and you may
also change it with the program
.B cdsf.
All 
.B csound
programs assume that an incomplete filename means to look in your home
directory by default.  
For instance, when you just say 
.B lsf 
by itself this is the directory 
.B lsf
examines.  You can
create subdirectories (branches) from this directory with 
.B mksfdir.
For instance:
.DS
% mksfdir noises
.DE
creates directory /your_sound_filesystem/your_login_name/noises.  
(The euphemism ``your_sound_filesystem'' refers to the name of the
sound file system you are assigned to when you got your login account.
It varies with each system.  At CARL, this will usually be ``/snda''.)
.PP
To use this directory, you must change your current sound file directory
to be this new one.  This is accomplished by the following statement:
.DS
% cdsf noises
.DE
Then saying
.DS
% ... | sndout fudge
.DE
will write a file /your_sound_filesystem/your_login_name/noises/fudge.  
This state of affairs will persist until you run
.B cdsf
again to change to a different directory.
You can see that the directory you supply to
.B cdsf 
determines where csound programs will subsequently
look for, or create, sound files (so long as a sound file directory
of that name exists).
You can change to other user's directories.
For instance:
.DS
% cdsf /his_sound_filesystem/frm
.DE
will cause the command
.DS
% sndin joy
.DE
to read file /his_sound_filesystem/frm/joy.  
.PP
To change back to your own home csound directory, it suffices to say simply,
.DS
% cdsf
.DE
by itself.
.PP
If you need to refresh your memory as to what directory you are in,
use the command
.B pwsf
which prints the current working sound file directory.
.NH 1
Relative Pathnames, Filenames
.PP
Sound file names used to be restricted to 10 characters or less; this
has been expanded under 4.2BSD UNIX so that the length of names is
virtually unlimited.
.PP
Unfortunately, csound supports no regular expression syntax.  This means,
for instance, that a command like
.DS
% lsf *
.DE
will not work.  This is because the UNIX shell interprets the ``*'' before
it is given to 
.B lsf.
The shell interprets the ``*'' to refer to all UNIX files in the current
UNIX directory, and can therefor not be used to indicate csound programs.
There are clever ways to subvert this limitation, but they go beyond the
scope of this document.
.PP
Relative pathnames are supported by all csound programs.  That is,
the pathnames ``.'' and ``..'', and the pathname prefixes ``./'' and ``../''
are legal parts of sound file names, and operate exactly as they do
in the UNIX file system.
.NH 1
Csound Programs
.LP
Here is a list of some of the currently available 
.B csound
programs.  The number in the first column is an indication as to
the ``relevance'' the program has to beginning users, with 0 being
important, and 9 being relatively unimportant.  Some recent additions
may be missing from this list.
.nf
.DS
0 lsf - list sound files, sound file directories
0 sndin - read csound files onto standard output
0 sndout - write sound files.
1 play - play sound file(s) through DACs
1 record - record sound file through ADCs
1 rmsf - remove sound file(s)
2 holdsf, keepsf - protect sound files from the purger
2 purgesf - purge over-ripe sound files
3 cpsf - move sound file
3 mvsf - move sound file
3 cdsf - change csound file directory
3 mksfdir - make a sound file directory
3 pwsf - print working sound file directory
4 sfck - check sound file system for soundness
4 sdc - print map of sound file block usage on a file system
5 catsf - concatenate sound files
5 sndcmp - compare two sound files.
5 sndhist  - produce histogram of sound file
6 visf - edit sound file parameters
9 dumpsf - dump sound files to tape
9 locksf, unlocksf - lock/unlock a sound file system
9 opensf - closesf - user-level commands to open/close sound files.
9 burpsf - free space compaction for csound file system
9 restorsf - restore sound files from magtape
9 sfdt - print csound dump statistics
.DE
.NH 1
Epilogue
.PP
There, now you know more than you need to know about the sound file system.
Go make some music.
