#define maxdl 14000
#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include "strums.h"
extern  strumq strumq1;
typedef struct {
        int p,del;
        float d[maxdl],c1,c2;
        } delayq;
extern  delayq dq;

extern SFHEADER      sfdesc[NFILES];

vstart1(p,n_args)
 float *p;
 int n_args;

/* 1-string guitar with delay and distortion, plus vibrato
 analogous to start4.c, which has an explaination of how to use it and how 
 it works.
 start1(star, dur, pitch, decay time, Ny freq decayt, dist gain,
 loop gain, loop pitch, premonitor, postmonitor, plamp,squish,
 vfreqlo, vfreqhi, vdepth, seed, pitch update, stereo spread)
 assumes makegen 1 is the vibrato function and makegen 2 is vib amp env */

  {
  float out[4],strum(),dist(),delay();
  float freq1,a,b,d,dgain,fbgain;
  long i,nsamps;
  int squish;
  int chans;
  float spread;

  float *vloc,*eloc,vsi,vsibot,vsitop,vsidiff,vphase;
  float freqch,tab[2],vamp;
  int vlen,elen,j,k;

  out[0]=out[1]=out[2]=out[3]=0.0;
  d = 0;

  nsamps=setnote(p[0],p[1],1);

  freq1=cpspch(p[2]);
  squish = p[11];
   
  dgain = p[5];
  fbgain = p[6]/dgain;
  sset(freq1,p[3],p[4],&strumq1);
  randfill(p[10],squish,&strumq1);
  delayset(cpspch(p[7]),&dq);
  delayclean(&dq);

  vlen = fsize(1);
  vloc = floc(1);
  vsibot = p[12] * (float)vlen/(float)SR;
  vsitop = p[13] * (float)vlen/(float)SR;
  vsidiff = vsibot - vsitop;
  srrand(p[15]);
  vsi = ((rrand()+1.0)/2.0) * vsidiff;
  vsi += vsibot;
  vphase = 0;

  elen = fsize(2);
  eloc = floc(2);
  tableset(p[1], elen, tab);

  j = (float)SR/freq1;
  k = (float)vlen/vsi;

  printf("set completed\n");

  spread = p[17];
  chans = sfchans(&sfdesc[1]);
  for (i=0;i<nsamps;i++) {
	while(!--k) {
		vsi = (( (rrand()+1.0)/2.0) * vsidiff) + vsibot;
		k =(float)vlen/vsi;
		}
	while(!--j) {
		vamp = tablei(i, eloc, tab) * p[14];
		freqch = oscili(vamp,vsi,vloc,vlen,&vphase);
		sset(freq1+freqch,p[3],p[4],&strumq1);
		j = (float)SR/(freq1+freqch);
		vphase += (float)j * vsi;
		}

      a = strum(d,&strumq1);

      b = dist(dgain*a);
      d = fbgain*delay(b,&dq);
      out[0] = (p[8]*a + p[9]*b) * p[10];
      if (chans == 2) {
         out[1] = (1.0 - spread) * out[0];
         out[0] *= spread;
         }
      ADDOUT(out,1);
      }
      printf("loopcompleted\n");
  
  endnote(1);
}
