#define maxdl 14000
#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include "strums.h"
extern  strumq strumq1;
extern  strumq strumq2;
extern  strumq strumq3;
extern  strumq strumq4;
typedef struct {
        int p,del;
        float d[maxdl],c1,c2;
        } delayq;
extern  delayq dq;

pick4(p,n_args)
 float *p;
 int n_args;

/* 4-string guitar with delay and distortion
   part of a set of 4 programs.  See start4.c for more info.
   pick4(star, dur, pitch, pitch, pitch, pitch, decay time, Ny freq decayt,
   dist gain,loop gain, loop pitch, premonitor, postmonitor, plamp,squish)  */

  {
  float out[4],strum(),dist(),delay();
  float freq1,freq2,freq3,freq4,a,b,d,dgain,fbgain;
  int squish;
  long i,nsamps;

  out[0]=out[1]=out[2]=out[3]=0.0;
  d = 0;

  nsamps=setnote(p[0],p[1],1);

  freq1=cpspch(p[2]);
  freq2=cpspch(p[3]);
  freq3=cpspch(p[4]);
  freq4=cpspch(p[5]);
   
  dgain = p[8];
  fbgain = p[9]/dgain;
  sset(freq1,p[6],p[7],&strumq1);
  sset(freq2,p[6],p[7],&strumq2);
  sset(freq3,p[6],p[7],&strumq3);
  sset(freq4,p[6],p[7],&strumq4);

  squish = p[14];
  randfill(p[13],squish,&strumq1);
  randfill(p[13],squish,&strumq2);
  randfill(p[13],squish,&strumq3);
  randfill(p[13],squish,&strumq4);
  delayset(cpspch(p[10]),&dq);
  printf("set completed\n");


  for (i=0;i<nsamps;i++) {
      a = strum(d,&strumq1);
      a += strum(d,&strumq2);
      a += strum(d,&strumq3);
      a += strum(d,&strumq4);

      b = dist(dgain*a);
      d = fbgain*delay(b,&dq);
      out[0] = p[11]*a + p[12]*b;
      ADDOUT(out,1);
      }
      printf("loopcompleted\n");
  
  endnote(1);
}
