#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include "strums.h"
extern strumq strumq1;

extern SFHEADER      sfdesc[NFILES];

bend(p,n_args)

 /* have pitch of plucked note follow curve.
    companion to start.c (see).

    bend(start t, dur, pitch0, pitch1, glissfcn, tf0, tNy, slow?, stereo spread)

    pitch0 pitch when function is at zero
    pitch1 pitch when function is a one
    glissfcn function number to follow pitch curve of
    slow? should normally be set to zero

    Normally updates pitch once per cycle
    On upwards glisses of notes that have very little harmonic content,
    this may result in buzzing.
    If this is not desired, a value of slow? = 1 will update pitch one/cycle,
    making it run slowly, but smoothly.     */

 float *p;
 int n_args;
  {
  float freq,freq0,freq1,out[4],strum();
  float diff,*glissf,tags[4];
  int gliss,leng,j,z;
  long i,nsamps;
  int chans;
  float spread;

  out[0]=out[1]=out[2]=out[3]=0.0;

  nsamps=setnote(p[0],p[1],1);

  freq0=cpspch(p[2]);
  freq1=cpspch(p[3]);
  diff = freq1 - freq0;

  sset(freq0,p[5],p[6],&strumq1);

        gliss = p[4];

        glissf = (float *)floc(gliss);  /*function p[4] is gliss shape */
        leng = fsize(gliss);

        j = 1; /*now just initing j, later interrupt  once per cycle*/
        z = 1;/*normally interrupt once/cycle*/
        if(p[7] == 1.) z = 0;  

        tableset(p[1],leng,tags);

	spread = p[8];
	chans = sfchans(&sfdesc[1]);
        for(i = 0; i<nsamps; i++) {
                if(!j--) { 
                        freq = diff*tablei(i,glissf,tags) + freq0;
                        sset(freq,p[5],p[6],&strumq1);
                        j = ((float)SR/freq+.5) * z;
                }  

        out[0]=strum(0.,&strumq1);
	if (chans == 2) {
		out[1] = (1.0 - spread) * out[0];
		out[0] *= spread;
		}
        ADDOUT(out,1);
        }
  
  endnote(1);
}
