#include "../../H/ugens.h"
#include "../../H/sfheader.h"
#include "../../H/combs.h"
#include "../../macros/macros.h"
#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <math.h>
#include <stdlib.h>

/* multicomb -- 4 simultaneous comb filters randomly chosen within
*	a specified range (spread across a stereo field)
*  p0 = input skip
*  p1 = output skip
*  p2 = output duration
*  p3 = amplitude multiplier
*  p4 = comb frequency range bottom
*  p5 = comb frequency range top
*  p6 = reverb time
*  assumes function table 1 is the amplitude envelope
*
*/

#define NCEES 4
#define ARRSIZE 32768

extern SFHEADER      sfdesc[NFILES];

double
multicomb(p,n_args)
float *p;
int n_args;
{
	long i,nsamps,n,count,smps = 0;
	float amp,val,cfreq,temp;
	float xin[2*ARRSIZE],out[2*ARRSIZE],*carray[NCEES],spread[NCEES];
	float *amparr,amptabs[2];
	int lenamp;
	int nmax,j,k;
	int inchans,skip;
	extern int resetval;

	setnote(p[0],p[2],0);
       	nsamps = setnote(p[1],p[2],1);

	if (sfchans(&sfdesc[1]) != 2) {
		fprintf(stderr,"I'm sorry, the output file has to be stereo for mutlicomb.\n");
		exit(-1);
		}

	amparr = floc(1);
	lenamp = fsize(1);
 	tableset(p[2], lenamp, amptabs);
	
	for (j = 0; j < NCEES; j++) {
		cfreq = (p[5] - p[4]) *  (rrand()+2.0)/2.0  + p[4];
		printf("comb number %d: %f\n",j,cfreq);
		nmax = SR/(int)cfreq + 4;
		if ( (carray[j] = (float *)malloc(nmax*FLOAT) )  == NULL) {
			fprintf(stderr,"Sorry, Charlie -- no space\n");
			exit(-1);
			}
		for (i = 0; i < nmax; i++) carray[j][i] = 0.0;

		combset(1.0/cfreq,p[6],0,carray[j]);
		spread[j] = (float)j/(float)(NCEES-1);
		}

	skip = SR/(float)resetval;
        j = 0;
        amp = p[3];
	inchans = sfchans(&sfdesc[0]);
        for (i = nsamps; i > 0; i -= ARRSIZE) {
		count = (i < ARRSIZE) ? i : ARRSIZE;
		count *= inchans;
		bgetin(xin,0,count);
		for (n = 0; n < count; n += inchans) {
			while (!j--) {
				val = tablei(smps,amparr,amptabs) * amp;
				j = skip;
				smps += skip;
				}
			out[n] = out[n+1] = 0;
			for (k = 0; k < NCEES; k++) {
/*				COMB(temp,xin[n],carray[k]);*/
				temp = comb(xin[n],carray[k]);
				out[n] += temp*spread[k];
				out[n+1] += temp*(1.0-spread[k]);
				}
			out[n] *= val;
			out[n+1] *= val;
			}
		baddout(out,1,count*2/inchans);
		}
       endnote(1);
}


int NBYTES = 16384;

profile()
{
	UG_INTRO("multicomb",multicomb);
	UG_INTRO("reset",reset);
}
