#include <iostream.h>
#include "../../sys/mixerr.h"
#include "../../rtstuff/Instrument.h"
#include "FMINST.h"
#include "../../rtstuff/rt.h"
#include "../../rtstuff/rtdefs.h"


extern "C" {
	#include "../../H/ugens.h"
	extern int resetval;
	}

FMINST::FMINST() : Instrument()
{
}

int FMINST::init(float p[], short n_args)
{
// p0 = start; p1 = dur; p2 = pitch of carrier (hz or oct.pc); 
// p3 = pitch of modulator (hz or oct.pc); p4 = fm index low point;
// p5 = fm index high point;  p6 = amp;  p7 = stereo spread (0-1) <optional>
// function slot 1 is oscillator waveform, slot 2 is the amp;
//    slot 3 is index guide

	nsamps = rtsetoutput(p[0], p[1], this);

	sine = floc(1);
	lensine = fsize(1);
	if (p[2] < 15.0) {
		sicar = cpspch(p[2]) * lensine/SR;
		}
	else {
		sicar = p[2] * lensine/SR;
		}
	
	if (p[3] < 15.0) {
		simod = cpspch(p[3]) * lensine/SR;
		}
	else {
		simod = p[3] * lensine/SR;
		}
	
	ampenv = floc(2);
	lenamp = fsize(2);
	tableset(p[1], lenamp, amptabs);
	
	indexenv = floc(3);
	lenind = fsize(3);
	tableset(p[1], lenind, indtabs);
	
	indbase = p[4];
	indbase *= simod;
	diff = (p[5] * simod) - indbase;
	
	amp = p[6];
	spread = p[7];
	skip = SR/(float)resetval;

	return(nsamps);
}

int FMINST::run()
{
	int i;
	float out[2];
	float aamp,val;
	int branch;

	branch = 0;
	for (i = 0; i < chunksamps; i++) {
		if (--branch < 0) {
			aamp = table(cursamp, ampenv, amptabs) * amp;
			index = diff * tablei(cursamp,indexenv,indtabs) + indbase;
			branch = skip;
			}

		val = oscil(index,simod,sine,lensine,&modphs);
		out[0] = osciln(aamp,sicar+val,sine,lensine,&carphs);

		if (NCHANS == 2) { /* split stereo files between the channels */
			out[1] = (1.0 - spread) * out[0];
			out[0] *= spread;
			}

		rtaddout(out);
		cursamp++;
		}
	return i;
}



Instrument*
makeFMINST()
{
	FMINST *inst;

	inst = new FMINST();
	return inst;
}

void
rtprofile()
{
	RT_INTRO("FMINST",makeFMINST);
}

