#include <iostream.h>
#include "../rtstuff/heap/heap.h"
#include "../rtstuff/rt.h"
#include "../rtstuff/rtdefs.h"


extern heap rtHeap;  // main heap structure from main.C
                     // formerly Qobject *rtqueue[]

extern "C" {
	int rtsendsamps();
	int rtgetsamps();  // DT:  for use with real-time audio input
	int audio_on;  // DT:  for use with real-time audio input
}

short outbuff[MAXBUF];
short *outbptr;
short inbuff[MAXBUF];  // DT:  for use with real-time audio input

void traverse()
{
  int i,j,chunksamps;
  unsigned long bufStartSamp;
  unsigned long bufEndSamp;

  unsigned long chunkStart;
  int offset,endsamp;
  Instrument *Iptr;

  // zero the output audio buffer
  for (j = 0; j < MAXBUF; j++)
    outbuff[j] = 0;
  

  // read in an input buffer (if audio input is active)
  if (audio_on) rtgetsamps();
    
  bufStartSamp = 0;  // current end sample for buffer
  bufEndSamp = RTBUFSAMPS;
  chunkStart = 0;
  
  while(rtHeap.getSize() > 0) {

    // check start time for next instrument
    chunkStart = rtHeap.getTop();
    
    if (chunkStart >= bufEndSamp) {  // we need to write a new buffer
      // send the old buffer to the dsp
      rtsendsamps();
      bufStartSamp += RTBUFSAMPS;
      bufEndSamp += RTBUFSAMPS;
      // zero the output audio buffer
      for (j = 0; j < (RTBUFSAMPS*NCHANS); j++)
	outbuff[j] = 0;
      // read in an input buffer (if audio input is active)
      if (audio_on) rtgetsamps();
    }
    
    // get top element off heap
    if (chunkStart < bufEndSamp) {
      Iptr = rtHeap.deleteMin();  // get next instrument off heap

      endsamp = Iptr->getendsamp();

      // difference in sample start (countdown)
      offset = (chunkStart-bufStartSamp)*NCHANS;  
      outbptr = &outbuff[offset];  // advance buffer pointer

      if (endsamp < bufEndSamp)  // compute # of samples to write
	chunksamps = endsamp-chunkStart;
      else {
	chunksamps = bufEndSamp-chunkStart;
      }

      Iptr->setchunk(chunksamps);  // set "chunksamps"
      Iptr->run();    // write the samples
    }
  }
}



