#import <libc.h>
#import <appkit/Application.h>
#import <appkit/TextField.h>
#import <soundkit/Sound.h>
#import <sound/soundstruct.h>
#import "cmixTransport.h"
#import "DACPlayer.h"
#import "errors.h"
#import <math.h>
int done = 0;
int inskip = 0;
int samples_to_do,frames_to_do,nchannels1,nchannels2,nchannels,number_of_buffers;
extern float timelist[6];
extern int oncode[6];
int currenttime=0;
int clocktime=0;
id aSound,aSound2;
int buffersize;

void UpdateStatus (DPSTimedEntry te, double timeNow, void *data)
{
  [(id)data updateStatus];
}


@implementation Transport:Object

+ new
{
  self = [super new];
  
  /* Create a timed entry to update the status window every second. */
  statusTE = DPSAddTimedEntry(1.0, &UpdateStatus, self, NX_BASETHRESHOLD);

  dacPlayer = [DACPlayer new];
  [dacPlayer setDelegate :self];

  return self;
}

- stop:sender;
{
  [dacPlayer stop];
  return self;
}

- pause:sender
{
  [dacPlayer pause];
  return self;
}

- tplay:(id)mySound with:(id)mySound2 bufcount:(int)nbuf
{
  number_of_buffers=nbuf;
  aSound = mySound;
  aSound2 = mySound2;
  
  nchannels1 = [aSound channelCount];
  nchannels2 = [aSound2 channelCount];
  nchannels = nchannels2;  /* output channels always equal to 2 */
  currenttime=1;
  done = inskip = 0;
  savesoundpointer = soundpointer = (short *)[aSound data];
  savesoundpointer2 = soundpointer2 = (short *)[aSound2 data];
  [dacPlayer setSamplingRate:(double)[aSound samplingRate]];
  [dacPlayer run];
  return self;
}

- wait
{
  [dacPlayer wait];
  [dacPlayer stop];
  return self;
}

/**
 ** Internal methods.
 **/
- updateStatus
{
  return self;
}

/**
 ** Delegate methods called from the DACPlayer object
 **/

- willPlay :player
/*
 * Called when the Player is about to start playing data.
 */
{
  id srateCell;
  int region_size, region_count;
 
  sampleValue = 0;
 
  /* set the current region size and count */

  buffersize = 32;
  region_size = buffersize * vm_page_size;
  nbuffers = region_count = number_of_buffers;
  
  [dacPlayer setupRegions:region_size:region_count];

   return self;
}

- didPlay :player;
/*
 * Called when the Player stops.
 */
{
   return self;
}

- playData :player :(char *)region :(int)nbytes
/*
 * Called whenever the Player wants more data. 
 */
{
      int i,j,blocksize, nsamples2,offset,r, nsamples = nbytes/BYTES_PER_16BIT;
   	
	
	r = vm_allocate(task_self(),(vm_address_t *)region, buffersize * vm_page_size, TRUE);


      while((clocktime=(timelist[4]-frames_to_do)) >= timelist[currenttime]) 	
		currenttime++;
      blocksize = (timelist[currenttime]-clocktime);
      nsamples2 = (blocksize > nsamples/nchannels) ? nsamples : blocksize*nchannels;

      switch(oncode[currenttime-1]) {
   		case 0: { 	/* nobody is playing */	
			if(samples_to_do > 0) {
				bzero(region,nsamples*BYTES_PER_16BIT); 
				samples_to_do -= nsamples2;
				frames_to_do -= nsamples2/2;
				}
    			else {
    				if(nbuffers-- == 2)
				done = 1;  /* count down DAC buffers */
				bzero(region,nsamples*BYTES_PER_16BIT); 
				}
			break;
			}
		case 2: {	/* just file1 is playing */
			if(samples_to_do > 0) {

				playfile1(region,nsamples2);   							
				samples_to_do -= nsamples2;
				frames_to_do -= nsamples2/2;

				}
    			else {
    				if(nbuffers-- == 2)
				done = 1;  /* count down DAC buffers */
				}
			break; }
		case 4: {	/* just file2 is playing */
			if(samples_to_do > 0) {

				playfile2(region,nsamples2);   							
				samples_to_do -= nsamples2;
				frames_to_do -= nsamples2/2;
				}
    			else {
    				if(nbuffers-- == 2)
				done = 1;  /* count down DAC buffers */
				}
			break; }
		case 6: {/* files 1 and 2 are playing */
   			if(samples_to_do > 0) {
   				mixfiles(aSound,aSound2,region,nsamples2);
   				samples_to_do -= nsamples2;
				frames_to_do -= nsamples2/2;

				}
    			else {
    				if(nbuffers-- == 2)
				done = 1;  /* count down DAC buffers */
				}
			break;
			}
		}

      if(blocksize <= nsamples/nchannels) {
      	   clocktime += nsamples2/nchannels;
	   offset = nsamples2*BYTES_PER_16BIT;
           nsamples2 = nsamples - blocksize*nchannels;

	   currenttime++;
           switch(oncode[currenttime-1]) {
   		case 0: { 	/* nobody is playing */	
			if((samples_to_do > 0)) {
				for(i=offset; i<nsamples*BYTES_PER_16BIT; i++) 
 
					(char *)region[i]=0; 
				samples_to_do -= nsamples2;
				frames_to_do -= nsamples2/2;
				}
    			else {
    				if(nbuffers-- == 2)
				done = 1;  /* count down DAC buffers */
				}
			break;
		}
		case 2: {	/* just file1 is playing */
			if(samples_to_do > 0) {

				playfile1(&region[offset],nsamples2);   							
				samples_to_do -= nsamples2;
				frames_to_do -= nsamples2/2;

				}
    			else {
    				if(nbuffers-- == 2)
				done = 1;  /* count down DAC buffers */
				}
			break; }
		case 4: {	/* just file2 is playing */
			if(samples_to_do > 0) {

				playfile2(&region[offset],nsamples2);   							
				samples_to_do -= nsamples2;
				frames_to_do -= nsamples2/2;
				}
    			else {
    				if(nbuffers-- == 2)
				done = 1;  /* count down DAC buffers */
				}
			break; }
		case 6: {/* files 1 and 2 are playing */	
   			if(samples_to_do > 0) {						
		mixfiles(aSound,aSound2,&region[offset],nsamples2);
   				samples_to_do -= nsamples2;
				frames_to_do -= nsamples2/2;
				}
    			else {
    				if(nbuffers-- == 2)
				done = 1;  /* count down DAC buffers */
				}
			break;
			}
		}
	}

	      return self;
}

@end
