/*
 *	ugens.h: define unit generator structure
 */
#define	UG_NSIZ	7	/*  Max len of UG name	*/
#define	UG_NULL	(struct ug_item *)0
#define NAMESIZE 128    /* Max size of file name */

#define FLOAT (sizeof(float))   /* nbytes in floating point word*/
#define INT   (sizeof(int))   /* nbytes in integer word */
#define SHORT (sizeof(short))
#define LONG  (sizeof(long))
#define NFILES       12       /* maximum number of opened files */

struct	ug_item	{
	struct	ug_item	*ug_next;
	double 	(*ug_ptr)();	/*  Pointer to the function	*/
	char	*ug_name;
};
typedef	struct ug_item	ug_t;

extern	ug_t	*ug_list;
extern	addfunc();

#define	UG_INTRO(flabel,func)	\
	{ extern double func();	\
		static ug_t this_ug = { UG_NULL, func, flabel }; \
		if (addfunc(&this_ug) == -1) merror(flabel);	}


#define      PI2    6.2831853
#define      PI     3.141592654
extern       float  SR;

#ifndef MAIN
extern int aargc;
extern char *aargv[];          /* to pass commandline args to subroutines */
#endif

 
/*  structure to pass to gen routines */
struct gen {
           int size;           /* size of array to load up */
           int nargs;          /* number of arguments passed in p array */
           float *pvals;       /* address of array of p values */
           float *array;       /* address of array to be loaded up */
	   int slot;	       /* slot number, for fnscl test */
           };
#ifndef SOUND
extern int (*addoutpointer[NFILES])();
extern int (*layoutpointer[NFILES])();
extern int (*wipeoutpointer[NFILES])();
extern int (*getinpointer[NFILES])();
extern int (*bwipeoutpointer[NFILES])();

#define ADDOUT(x,y)  (*addoutpointer[y])(x,y)
#define LAYOUT(x,l,y)  (*layoutpointer[y])(x,l,y)
#define WIPEOUT(x,y) (*wipeoutpointer[y])(x,y)
#define GETIN(x,y)   (*getinpointer[y])(x,y)
#define BWIPEOUT(x,y,z) (*bwipeoutpointer[y])(x,y,z)
#endif  SOUND
#define  ABS(x) ((x < 0) ? (-x) : (x))
#define  SIGN(x) (ABS(x)/(x ? x : 1.))

/* declarations of units */
long  setnot();
float reson(),resonz(),oscil(),oscili(),osciln(),oscilni(),evp(),table(),tablei();
float cpspch(),pchcps(),cpsoct(),octcps(),pchoct(),buzz(),allpole();
float delget(),dliget(),boost(),rrand();
float octpch(),*floc(),reverb(),bpluck(),hpluck(),hcomb(),comb();
float allpass(),allpole(),ballpole(),bbuzz(),boscili(),
	delput(),crandom(),random();
double ampdb();
float pluck(),randf();
float pchmidi();
int midipch();

int (*getsample)();
#define GETSAMPLE (*getsample)
