/* soup_in.h   14-12-93  Artificial Life simulator setup routines */
/* Tierra Simulator V4.1: Copyright (c) 1991, 1992, 1993 */
/* Tom Ray & Virtual Life */

/*
 * sccsid: @(#)soup_in.h	1.5	7/21/92
 */

#include "license.h"

#ifndef SOUP_IN_H
#define SOUP_IN_H

/* observational parameters: */

I32s BrkupSiz = 1024;  /* size of output file in K: break.1, break.2 ... */
I32s CumGeneBnk = 0;    /* Use cumulative gene files, or overwrite */
I32s debug = 0;	       /* 0 = off, 1 = on, printf statements for debugging */
I32s DiskOut = 1;      /* output data to disk (1 = on, 0 = off) */
I32s GeneBnker = 1;    /* turn genebanker on and off */
I8s GenebankPath[80] = "gb/";	/* path for genebanker output */
I32s hangup = 0;    /* 0 = exit on error, 1 = hangup on error for debugging */
I32s Log = 0;    /* 0 = no log file, 1 = write tierra.log file to disk */
I32s MaxFreeBlocks = 600;/* initial # of structure for memory allocation */
I8s OutPath[80] = "td/";	/* path for data output */
I32s RamBankSiz = 30000;/* max num genotypes in ram, use with genebanker */
I32s SaveFreq = 100;   /* frequency of saving core_out, soup_out and list */
I32s  SavMinNum = 2;   /* minimum number of individuals to save genotype */
float SavThrMem = .015;/* threshold memory occupancy to save genotype */
float SavThrPop = .015;/* threshold population proportion to save genotype */
I32s WatchExe = 0;     /* mark executed instructions in genome in genebank */
I32s WatchMov = 0;     /* set mov bits in genome in genebank */
I32s WatchTem = 0;     /* set template bits in genome in genebank */

/* environmental variables: */

I32s alive = 500;      /* how many millions of instruction will we run */
float DistFreq = .3;    /* frequency of disturbance, factor of recovery time */
float DistProp = .2;   /* proportion of population affected by distrubance */
I32s DivSameSiz = 0;   /* produce offspring of same size, stop size change */
I32s DivSameGen = 0;  /* produce offspring of same genotype, stop evolution */
I32s DropDead = 5;     /* stop system if no reproduction in last x million */
I32s EjectRate = 50; /* rate at which cells are randomly ejected from soup */
float GenPerBkgMut = 16.; /* mut rate control by generations ("cosmic ray") */
float GenPerFlaw = 32.;/* flaw control by generations */
float GenPerMovMut = 8.;/* mutation rate control by generations (copy mut) */
I8s IMapFile[80] = "opcode.map"; /* map of instructions set into space */
float JmpSouTra = 1.; /* source track switches per average size */
float JumpTrackProb = .2; /* prob of switching track during jump of IP */
I32s MalMode = 2; /* 0 = first fit, 1 = better fit, 2 = random preference,
3 = near mother's address, 4 = near dx address, 5 = near top of stack address*/
I32s MalReapTol = 1; /* 0 = reap by queue, 1 = reap oldest creat wthn MalTol */
I32s MalTol = 5; /* multiple of avgsize to search for free block */
float MateProb = .2;	/* probability of mating, this mal */
I32s MateSearchL = 0;	/* Search limit to find a mate, like SearchLimit */
I32s MateSizeEp = 1;	/* critters size +- val => allowed to mate with */
float MateXoverProp = 1.0; /* prop. of gene to consider for Xover point */
I32s  MaxCpuPerCell = 16; /* maximum number of CPUs allowed per cell */
float MaxMalMult = 3;  /* multiple of cell size allowed for mal() */
I32s MinCellSize = 8;  /* minimum size for cells */
I32s MinTemplSize = 1; /* minimum size for templates */
float MovPropThrDiv = .7;/* min proportion of daughter cell filled by mov */
I32s MemModeFree = 0;  /* unix chmod for when mem is dealloced,  */
I32s MemModeMine = 0;  /* unix chmod for when mem is owned by creature,  */
I32s MemModeProt = 2;  /* unix chmod, mem is owned by another creature */
I32s new_soup = 1;     /* 1 = this a new soup, 0 = restarting an old run */
I32s NumCells = 1;    /* # of creatures and gaps used to inoculate new soup */
double PhotonPow = 1.5;/* power for photon match slice size */
I32s PhotonWidth = 8;  /* amount by which photons slide to find best fit */
I8s PhotonWord[80] = "chlorophill";	/* word used to define photon */
float PutLimit = 20.;   /* distance for intercellular communication */
float ReapRndProp = 0.0; /* rnd prop of top of reaper Q to reap from */
float SearchLimit = 5.;   /* distance for template search */
I32s seed = 0; /* seed for random number generator, 0 uses time to set seed */
I32s SizDepSlice = 1;  /* set slice size by size of creature */
double SlicePow = 1;  /* set power for slice size, use when SizDepSlice = 1 */
I32s SliceSize = 25;   /* slice size when SizDepSlice = 0 */
I32s SliceStyle = 2;   /* choose style of determining slice size */
float SlicFixFrac = 0; /* fixed fraction of slice size */
float SlicRanFrac = 2; /* random fraction of slice size */
I32s SoupSize = 60000L;  /* size of soup in instructions */

InstDef *id;

InstDef idt[] = {
    {0, "nop0", nop, pnop, "", 0, 0, 0},              /* no parse args */
    {0, "nop1", nop, pnop, "", 0, 0, 0},              /* no parse args */
    {0, "add", math, dec1d2s, "", 0, 0, 0},           /* "rrr" */
    {0, "adrb", adr, decadr, "", 0, 0, 0},            /* "rr  " */
    {0, "adrf", adr, decadr, "", 0, 0, 0},            /* "rr  " */
    {0, "adro", adr, decadr, "", 0, 0, 0},            /* "rr  " */
    {0, "call", tcall, ptcall, "", 0, 0, 0},          /* no parse args */
    {0, "dec", math, dec1d1s, "", 0, 0, 0},           /* "rr" */
    {0, "decC", math, dec1d1s, "cc", 0, 0, 0},        /* "cc" */
    {0, "divide", divide, dec2s, "", 0, 0, 0},        /* "rr" */
    {0, "enter", enter, pnop, "", 0, 0, 0},           /* no parse args */
    {0, "equal", skip, dec2s, "", 0, 0, 0},           /* "rr" */
    {0, "exch", exch, dec2s, "", 0, 0, 0},            /* "rr" */
    {0, "greater", skip, dec2s, "", 0, 0, 0},         /* "rr" */
    {0, "iffl", skip, dec2s, "", 0, 0, 0},            /* "rr" */
    {0, "ifz", skip, dec2s, "", 0, 0, 0},             /* "rr" */
    {0, "inc", math, dec1d1s, "", 0, 0, 0},           /* "rr" */
    {0, "incA", math, dec1d1s, "aa", 0, 0, 0},        /* "aa" */
    {0, "incB", math, dec1d1s, "bb", 0, 0, 0},        /* "bb" */
    {0, "incC", math, dec1d1s, "cc", 0, 0, 0},        /* "cc" */
    {0, "jmpb", adr, decjmp, "", 0, 0, 0},            /* "r" */
    {0, "jmpf", adr, decjmp, "", 0, 0, 0},            /* "r" */
    {0, "jmpo", adr, decjmp, "", 0, 0, 0},            /* "r" */
    {0, "join", join, pnop, "", 0, 0, 0},             /* no parse args */
    {0, "less", skip, dec2s, "", 0, 0, 0},            /* "rr" */
    {0, "mal", malchm, dec1d3s, "", 0, 0, 0},         /* "rr r" */
    {0, "movBA", movdd, dec1d1s, "ba", 0, 0, 0},      /* "ba" */
    {0, "movDC", movdd, dec1d1s, "dc", 0, 0, 0},      /* "dc" */
    {0, "movdd", movdd, dec1d1s, "", 0, 0, 0},        /* "rr" */
    {0, "movdi", movdi, pmovdi, "", 0, 0, 0},         /* "rr" */
    {0, "movid", movid, pmovid, "", 0, 0, 0},         /* "rr" */
    {0, "movii", movii, pmovii, "", 0, 0, 0},         /* "rr" */
    {0, "not", not, dec1d, "", 0, 0, 0},              /* "r" */
    {0, "not0", not0, dec1d, "", 0, 0, 0},            /* "r" */
    {0, "offAACD", offset, dec1d3s, "aacd", 0, 0, 0}, /* "aacd" */
    {0, "offBBCD", offset, dec1d3s, "bbcd", 0, 0, 0}, /* "bbcd" */
    {0, "offset", offset, dec1d3s, "", 0, 0, 0},      /* "rrrr" */
    {0, "pop", pop, dec1d, "", 0, 0, 0},              /* "r" */
    {0, "popA", pop, dec1d, "a", 0, 0, 0},            /* "a" */
    {0, "popB", pop, dec1d, "b", 0, 0, 0},            /* "b" */
    {0, "popC", pop, dec1d, "c", 0, 0, 0},            /* "c" */
    {0, "popD", pop, dec1d, "d", 0, 0, 0},            /* "d" */
    {0, "push", push, dec1s, "", 0, 0, 0},            /* "r" */
    {0, "pushA", push, dec1s, "a", 0, 0, 0},          /* "a" */
    {0, "pushB", push, dec1s, "b", 0, 0, 0},          /* "b" */
    {0, "pushC", push, dec1s, "c", 0, 0, 0},          /* "c" */
    {0, "pushD", push, dec1s, "d", 0, 0, 0},          /* "d" */
    {0, "rand", movdd, dec1d1s, "", 0, 0, 0},         /* "rr" */
    {0, "ret", pop, dec1d, "", 0, 0, 0},              /* no parse args */
    {0, "rolld", rolld, pnop, "", 0, 0, 0},           /* no parse args */
    {0, "rollu", rollu, pnop, "", 0, 0, 0},           /* no parse args */
    {0, "shl", shl, dec1d, "", 0, 0, 0},              /* "r" */
    {0, "shr", shr, dec1d, "", 0, 0, 0},              /* "r" */
    {0, "split", split, dec1d1s, "", 0, 0, 0},        /* "rr" */
    {0, "sub", math, dec1d2s, "", 0, 0, 0},           /* "rrr" */
    {0, "subCAB", math, dec1d2s, "cab", 0, 0, 0},     /* "cab" */
    {0, "subAAC", math, dec1d2s, "aac", 0, 0, 0},     /* "aac" */
    {0, "zero", movdd, dec1d1s, "", 0, 0, 0},         /* "rr" */
    {0, "zeroD", movdd, dec1d1s, "dd", 0, 0, 0},      /* "dd" */
    {0, "csync", csync, pnop, "", 0, 0, 0},           /* no parse args */
    {0, "getregs", getregs, dec1s, "t", 0, 0, 0},     /* "#" */
#ifdef I/O
    {0, "get", get, dec1d1s, "", 0, 0, 0},            /* "r" */
    {0, "put", put, dec1d1s, "", 0, 0, 0},            /* "rr" */
    {0, "puticc", puticc, pputicc, "", 0, 0, 0},      /* "rr" */
#endif /* I/O */
#if PLOIDY > 1
    {0, "trso", trso, pnop, "", 0, 0, 0},             /* no parse args */
    {0, "trde", trde, pnop, "", 0, 0, 0},             /* no parse args */
    {0, "trex", trex, pnop, "", 0, 0, 0},             /* no parse args */
#else /* PLOIDY > 1 */
    {0, "trso", NULL, NULL, "", 0, 0, 0},
    {0, "trde", NULL, NULL, "", 0, 0, 0},
    {0, "trex", NULL, NULL, "", 0, 0, 0},
#endif /* PLOIDY > 1 */
#ifdef SHADOW
    {0, "A", regorder, dec1s, "a", 0, 0, 0},          /* "a" */
    {0, "B", regorder, dec1s, "b", 0, 0, 0},          /* "b" */
    {0, "C", regorder, dec1s, "c", 0, 0, 0},          /* "c" */
    {0, "D", regorder, dec1s, "d", 0, 0, 0},          /* "d" */
#else /* SHADOW */
    {0, "A", NULL, NULL, "", 0, 0, 0},
    {0, "B", NULL, NULL, "", 0, 0, 0},
    {0, "C", NULL, NULL, "", 0, 0, 0},
    {0, "D", NULL, NULL, "", 0, 0, 0},
#endif /* SHADOW */
    {0, "END", NULL, NULL, "", 0, 0, 0}
};

#endif /* SOUP_IN_H */
