'\"
'\" Copyright (c) 1992 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: grab.n,v 1.9 2000/10/11 21:51:52 spolk Exp $
'\" 
.so man.macros
.TH grab n "" Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
grab \- Confine pointer and keyboard events to a window sub-tree
.SH SYNOPSIS
\fBgrab \fR?\fB\-global\fR? \fIwindow\fR
.sp
\fBgrab \fIoption \fR?\fIarg arg \fR...?
.BE

.SH DESCRIPTION
.PP
This command implements simple pointer and keyboard grabs for Tk.
Tk's grabs are different than the grabs
described in the Xlib documentation.
When a grab is set for a particular window, Tk restricts all pointer
events to the grab window and its descendants in Tk's window hierarchy.
Whenever the pointer is within the grab window's subtree, the pointer
will behave exactly the same as if there had been no grab at all
and all events will be reported in the normal fashion.
When the pointer is outside \fIwindow\fR's tree, button presses and
releases and
mouse motion events are reported to \fIwindow\fR, and window entry
and window exit events are ignored.
The grab subtree ``owns'' the pointer:
windows outside the grab subtree will be visible on the screen
but they will be insensitive until the grab is released.
The tree of windows underneath the grab window can include top-level
windows, in which case all of those top-level windows
and their descendants will continue to receive mouse events
during the grab.
.PP
Two forms of grabs are possible:  local and global.
A local grab affects only the grabbing application:  events will
be reported to other applications as if the grab had never occurred.
Grabs are local by default.
A global grab locks out all applications on the screen,
so that only the given subtree of the grabbing application will be
sensitive to pointer events (mouse button presses, mouse button releases,
pointer motions, window entries, and window exits).
During global grabs the window manager will not receive pointer
events either.
.PP
During local grabs, keyboard events (key presses and key releases)
are delivered as usual:  the window
manager controls which application receives keyboard events, and
if they are sent to any window in the grabbing application then they are
redirected to the focus window.
During a global grab Tk grabs the keyboard so that all keyboard events
are always sent to the grabbing application.
The \fBfocus\fR command is still used to determine which window in the
application receives the keyboard events.
The keyboard grab is released when the grab is released.
.PP
Grabs apply to particular displays.  If an application has windows
on multiple displays then it can establish a separate grab on each
display.
The grab on a particular display affects only the windows on
that display.
It is possible for different applications on a single display to have
simultaneous local grabs, but only one application can have a global
grab on a given display at once.
.PP
The \fBgrab\fR command can take any of the following forms:
.TP
\fBgrab \fR?\fB\-global\fR? \fIwindow\fR
Same as \fBgrab set\fR, described below.
.TP
\fBgrab current \fR?\fIwindow\fR?
If \fIwindow\fR is specified, returns the name of the current grab
window in this application for \fIwindow\fR's display, or an empty
string if there is no such window.
If \fIwindow\fR is omitted, the command returns a list whose elements
are all of the windows grabbed by this application for all displays,
or an empty string if the application has no grabs.
.TP
\fBgrab release \fIwindow\fR
Releases the grab on \fIwindow\fR if there is one, otherwise does
nothing.  Returns an empty string.
.TP
\fBgrab set \fR?\fB\-global\fR? \fIwindow\fR
Sets a grab on \fIwindow\fR.  If \fB\-global\fR is specified then the
grab is global, otherwise it is local.
If a grab was already in effect for this application on
\fIwindow\fR's display then it is automatically released.
If there is already a grab on \fIwindow\fR and it has the same
global/local form as the requested grab, then the command
does nothing.  Returns an empty string.
.TP
\fBgrab status \fIwindow\fR
Returns \fBnone\fR if no grab is currently set on \fIwindow\fR,
\fBlocal\fR if a local grab is set on \fIwindow\fR, and
\fBglobal\fR if a global grab is set.

.SH BUGS
.PP
It took an incredibly complex and gross implementation to produce
the simple grab effect described above.
Given the current implementation, it isn't safe for applications
to use the Xlib grab facilities at all except through the Tk grab
procedures.
If applications try to manipulate X's grab mechanisms directly,
things will probably break.
.PP
If a single process is managing several different Tk applications,
only one of those applications can have a local grab for a given
display at any given time.  If the applications are in different
processes, this restriction doesn't exist.

.SH KEYWORDS
grab, keyboard events, pointer events, window
