dnl This provides configure definitions used by all the examples
dnl configure.in files.

dnl This calls basic introductory stuff, including AM_INIT_AUTOMAKE
dnl and AC_CANONICAL_HOST. The only argument is the relative path
dnl to the top bsp directory.

AC_DEFUN(EXAMPLES_CONFIGURE,
[
dnl Default to --enable-multilib
AC_ARG_ENABLE(multilib,
[  --enable-multilib         build many library versions (default)],
[case "${enableval}" in
  yes) multilib=yes ;;
  no)  multilib=no ;;
  *)   AC_MSG_ERROR(bad value ${enableval} for multilib option) ;;
 esac], [multilib=yes])dnl

dnl We may get other options which we don't document:
dnl --with-target-subdir, --with-multisrctop, --with-multisubdir

test -z "[$]{with_target_subdir}" && with_target_subdir=.

if test "[$]{srcdir}" = "."; then
  if test "[$]{with_target_subdir}" != "."; then
    examples_basedir="[$]{srcdir}/[$]{with_multisrctop}../$1"
  else
    examples_basedir="[$]{srcdir}/[$]{with_multisrctop}$1"
  fi
else
  examples_basedir="[$]{srcdir}/$1"
fi
AC_SUBST(examples_basedir)

AC_CANONICAL_HOST

AM_INIT_AUTOMAKE(examples, 1.0)

dnl FIXME: We temporarily define our own version of AC_PROG_CC.  This is
dnl copied from autoconf 2.12, but does not call AC_PROG_CC_WORKS.  We
dnl are probably using a cross compiler, which will not be able to fully
dnl link an executable.  This should really be fixed in autoconf
dnl itself.

AC_DEFUN(LIB_AC_PROG_CC,
[AC_BEFORE([$0], [AC_PROG_CPP])dnl
AC_CHECK_PROG(CC, gcc, gcc)
if test -z "$CC"; then
  AC_CHECK_PROG(CC, cc, cc, , , /usr/ucb/cc)
  test -z "$CC" && AC_MSG_ERROR([no acceptable cc found in \$PATH])
fi

AC_PROG_CC_GNU

if test $ac_cv_prog_gcc = yes; then
  GCC=yes
dnl Check whether -g works, even if CFLAGS is set, in case the package
dnl plays around with CFLAGS (such as to build both debugging and
dnl normal versions of a library), tasteless as that idea is.
  ac_test_CFLAGS="${CFLAGS+set}"
  ac_save_CFLAGS="$CFLAGS"
  CFLAGS=
  AC_PROG_CC_G
  if test "$ac_test_CFLAGS" = set; then
    CFLAGS="$ac_save_CFLAGS"
  elif test $ac_cv_prog_cc_g = yes; then
    CFLAGS="-g -O2"
  else
    CFLAGS="-O2"
  fi
else
  GCC=
  test "${CFLAGS+set}" = set || CFLAGS="-g"
fi
])

LIB_AC_PROG_CC

# Likewise for AC_PROG_CXX.  We can't just call it directly because g++
# will try to link in libstdc++.
AC_DEFUN(LIB_AC_PROG_CXX,
[AC_BEFORE([$0], [AC_PROG_CXXCPP])dnl
dnl Fool anybody using AC_PROG_CXX.
AC_PROVIDE([AC_PROG_CXX])
AC_CHECK_PROGS(CXX, $CCC c++ g++ gcc CC cxx cc++, gcc)
AC_SUBST(CXX)
test -z "$CXX" && AC_MSG_ERROR([no acceptable c++ found in \$PATH])

AC_PROG_CXX_GNU

if test $ac_cv_prog_gxx = yes; then
  GXX=yes
  dnl Check whether -g works, even if CXXFLAGS is set, in case the package
  dnl plays around with CXXFLAGS (such as to build both debugging and
  dnl normal versions of a library), tasteless as that idea is.
  ac_test_CXXFLAGS="${CXXFLAGS+set}"
  ac_save_CXXFLAGS="$CXXFLAGS"
  CXXFLAGS=
  AC_PROG_CXX_G
  if test "$ac_test_CXXFLAGS" = set; then
    CXXFLAGS="$ac_save_CXXFLAGS"
  elif test $ac_cv_prog_cxx_g = yes; then
    CXXFLAGS="-g -O2"
  else
    CXXFLAGS="-O2"
  fi
else
  GXX=
  test "${CXXFLAGS+set}" = set || CXXFLAGS="-g"
fi
])

LIB_AC_PROG_CXX

dnl AC_CHECK_TOOL does AC_REQUIRE (AC_CANONICAL_BUILD).  If we don't
dnl run it explicitly here, it will be run implicitly before
dnl EXAMPLES_CONFIGURE, which doesn't work because that means that it will
dnl be run before AC_CANONICAL_HOST.
AC_CANONICAL_BUILD

AC_CHECK_TOOL(AS, as)
AC_CHECK_TOOL(AR, ar)
AC_CHECK_TOOL(RANLIB, ranlib, :)

AC_PROG_INSTALL

AM_MAINTAINER_MODE

dnl We need AC_EXEEXT to keep automake happy in cygnus mode.  However,
dnl at least currently, we never actually build a program, so we never
dnl need to use $(EXEEXT).  Moreover, the test for EXEEXT normally
dnl fails, because we are probably configuring with a cross compiler
dnl which can't create executables.  So we include AC_EXEEXT to keep
dnl automake happy, but we don't execute it, since we don't care about
dnl the result.
if false; then
  AC_EXEEXT
fi

tooldir='$(exec_prefix)/$(host_alias)'
toollibdir='$(tooldir)/lib$(multisubdir)'
AC_SUBST(tooldir)
AC_SUBST(toollibdir)

multisubdir=
if test x[$]{with_multisubdir} != x; then
  multisubdir=/[$]{with_multisubdir}
fi
AC_SUBST(multisubdir)

])
