#############################################################
#
# ntp
#
#############################################################
ifneq ($(USE_CVS),true)
NTP_SOURCE:=ntp.tar.gz
NTP_SITE:=http://www.eecis.udel.edu/~ntp/ntp_spool/ntp4
NTP_DIR:=$(BUILD_DIR)/${shell basename $(NTP_SOURCE) .tar.gz}
NTP_CAT:=zcat
else
# using CVS
NTP_DIR:=$(BUILD_DIR)/ntp
endif

NTP_BINARY:=ntpdate/ntpdate
NTP_TARGET_BINARY:=usr/sbin/ntpdate

ifneq ($(USE_CVS),true)
ntp-fetch:
	 $(WGET) -P $(DL_DIR) $(NTP_SITE)/$(NTP_SOURCE)

ntp-source: $(DL_DIR)/$(NTP_SOURCE)
else
ntp-source:
endif

NTP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d ntp $(CVS_TAG) $(CVS_PREFIX)ntp

ntp-checkout:
	@$(NTP_CVSCO)

$(NTP_DIR)/.unpacked: $(DL_DIR)/$(NTP_SOURCE)
ifneq ($(USE_CVS),true)
	$(NTP_CAT) $(DL_DIR)/$(NTP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NTP_CVSCO)
endif
	sed -i -e "s,^#if.*__GLIBC__.*_BSD_SOURCE.*$$,#if 0," \
		$(NTP_DIR)/ntpd/refclock_pcf.c;
	cp $(SOURCE_DIR)/config.sub $(NTP_DIR)/
	touch $(NTP_DIR)/.unpacked

$(NTP_DIR)/.configured: $(NTP_DIR)/.unpacked
	(cd $(NTP_DIR); rm -rf config.cache; \
		CFLAGS="$(TARGET_CFLAGS)" \
		$(TARGET_CONFIGURE_OPTS) \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/sbin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--with-shared \
		--program-prefix= \
	);
	touch  $(NTP_DIR)/.configured

$(NTP_DIR)/$(NTP_BINARY): $(NTP_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(NTP_DIR)

$(TARGET_DIR)/$(NTP_TARGET_BINARY): $(NTP_DIR)/$(NTP_BINARY)
	touch $(TARGET_DIR)/touchme
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(NTP_DIR) install
	rm -rf $(TARGET_DIR)/share/locale
	@echo "Stripping NTP binaries..."
	@for f in `find $(TARGET_DIR) -type f -newer $(TARGET_DIR)/touchme -exec file {} \; | \
		grep "ELF.*executable.*not stripped" | cut -d : -f 1` ; do \
	    $(STRIP) $$f ; \
	done
	rm -f $(TARGET_DIR)/touchme
	if [ -d $(TARGET_DIR)/etc/rc.d/init.d ]; then \
		install -m0755 $(NTP_DIR)/redhat/ntpd.init \
			$(TARGET_DIR)/etc/rc.d/init.d/ntpd ;\
		install -m0644 $(NTP_DIR)/redhat/ntp.conf \
			$(TARGET_DIR)/etc ; \
		echo 'OPTIONS="-p /var/run/ntpd.pid"' > $(TARGET_DIR)/etc/sysconfig/ntpd; \
	fi
	mkdir -p $(DOC_DIR)/doc/ntp
	for f in COPYRIGHT NEWS README ; do \
	    install -m0644 $(NTP_DIR)/$$f $(DOC_DIR)/doc/ntp/$$f ; \
	done
	cp -a $(NTP_DIR)/html $(DOC_DIR)/doc/ntp/
	-find $(DOC_DIR)/doc/ntp -name CVS | xargs rm -rf 2>/dev/null

ntp: uclibc $(TARGET_DIR)/$(NTP_TARGET_BINARY)

ntp-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(NTP_DIR) uninstall
	-rm -f $(TARGET_DIR)/etc/rc.d/init.d/ntpd \
		$(TARGET_DIR)/etc/ntp.conf
	-$(MAKE) -C $(NTP_DIR) clean
	-rm -rf $(DOC_DIR)/doc/ntp

ntp-dirclean:
	rm -rf $(NTP_DIR)

