#############################################################
#
# glib2
#
#############################################################
ifneq ($(USE_CVS), true)
GLIB2_SOURCE:=glib2.tar.gz
GLIB2_CAT:=zcat
endif

GLIB2_DIR:=$(BUILD_DIR)/glib2
$(DL_DIR)/$(GLIB2_SOURCE):

ifneq ($(USE_CVS),true)
glib2-source: $(DL_DIR)/$(GLIB2_SOURCE)
else
glib2-source:
endif

GLIB2_SO:=usr/lib/libglib-2.0.so

GLIB2_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d glib2 $(CVS_TAG) $(CVS_PREFIX)glib2

glib2-checkout:
	@$(GLIB2_CVSCO)

$(GLIB2_DIR)/.unpacked: $(DL_DIR)/$(GLIB2_SOURCE)
ifneq ($(USE_CVS), true)
	$(GLIB2_CAT) $(DL_DIR)/$(GLIB2_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(GLIB2_CVSCO)
endif
	-cat $(SOURCE_DIR)/glib2.patch | patch -p0 -d $(GLIB2_DIR)
	cp $(SOURCE_DIR)/config.sub $(GLIB2_DIR)
	touch  $(GLIB2_DIR)/.unpacked

/usr/bin/glib-genmarshal:
	@echo "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
	@echo "@"
	@echo "@ The glib2-devel package must be installed on"
	@echo "@ the build host in order to build glib2"
	@echo "@"
	@echo "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
	/bin/false

$(GLIB2_DIR)/.configured: $(GLIB2_DIR)/.unpacked /usr/bin/glib-genmarshal
	cd $(GLIB2_DIR); \
	rm -rf config.cache; \
	$(TARGET_CONFIGURE_OPTS) \
	CFLAGS="$(TARGET_CFLAGS)" \
	    ./configure \
	    --target=$(GNU_TARGET_NAME) \
	    --host=$(GNU_TARGET_NAME) \
	    --build=$(GNU_HOST_NAME) \
	    --prefix=/usr \
	    --exec-prefix=/usr
	touch  $(GLIB2_DIR)/.configured

$(GLIB2_DIR)/$(GLIB2_LIBRARY): $(GLIB2_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(GLIB2_DIR)

$(TARGET_DIR)/$(GLIB2_SO): $(GLIB2_DIR)/$(GLIB2_LIBRARY)
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(GLIB2_DIR) install
	rm -rf $(TARGET_DIR)/usr/share/glib-2.0 \
		$(TARGET_DIR)/usr/share/gtk-doc \
		$(TARGET_DIR)/usr/share/locale/*/LC_MESSAGES/glib2.mo

$(STAGING_DIR)/$(GLIB2_SO): $(GLIB2_DIR)/$(GLIB2_LIBRARY)
	$(MAKE) DESTDIR=$(STAGING_DIR) -C $(GLIB2_DIR) install

glib2: uclibc $(STAGING_DIR)/$(GLIB2_SO) $(TARGET_DIR)/$(GLIB2_SO)

glib2-clean:
	-$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(GLIB2_DIR) uninstall
	-rm -f $(TARGET_DIR)/$(GLIB2_SO) $(STAGING_DIR)/$(GLIB2_SO)
	-$(MAKE) -C $(GLIB2_DIR) clean

glib2-dirclean:
	rm -rf $(GLIB2_DIR)

