#############################################################
#
# cracklib
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
CRACKLIB_SOURCE:=cracklib.tar.gz
CRACKLIB_CAT:=zcat
endif

CRACKLIB_DIR:=$(BUILD_DIR)/cracklib
CRACKLIB_BINARY:=cracklib/libcrack.so.2.7
CRACKLIB_TARGET_BINARY:=usr/sbin/mkdict

ifneq ($(USE_CVS),true)
cracklib-source: $(DL_DIR)/$(CRACKLIB_SOURCE)
else
cracklib-source:
endif

CRACKLIB_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d cracklib $(CVS_TAG) $(CVS_PREFIX)cracklib

cracklib-checkout:
	@$(CRACKLIB_CVSCO)

$(CRACKLIB_DIR)/.unpacked: $(DL_DIR)/$(CRACKLIB_SOURCE)
ifneq ($(USE_CVS),true)
	$(CRACKLIB_CAT) $(DL_DIR)/$(CRACKLIB_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(CRACKLIB_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(CRACKLIB_DIR)/
	touch $(CRACKLIB_DIR)/.unpacked

$(CRACKLIB_DIR)/$(CRACKLIB_BINARY): $(CRACKLIB_DIR)/.unpacked
	$(MAKE) \
		CC=$(TARGET_CC) \
		LD=$(TARGET_CROSS)ld \
		-C $(CRACKLIB_DIR) \
		all

$(STAGING_DIR)/$(CRACKLIB_TARGET_BINARY): $(CRACKLIB_DIR)/$(CRACKLIB_BINARY)
	-$(MAKE) \
		ROOT=$(STAGING_DIR) \
		-C $(CRACKLIB_DIR) \
		install

$(TARGET_DIR)/$(CRACKLIB_TARGET_BINARY): $(STAGING_DIR)/$(CRACKLIB_TARGET_BINARY)
	cp $(SOURCE_DIR)/cracklib_dict.* $(TARGET_DIR)/usr/lib/
	-$(MAKE) \
		ROOT=$(TARGET_DIR) \
		-C $(CRACKLIB_DIR) \
		install
	-rm -f $(TARGET_DIR)/usr/include/crack.h
	install -d $(DOC_DIR)/doc/cracklib
	@for f in LICENCE README ; do \
		install -m0644 $(CRACKLIB_DIR)/$$f $(DOC_DIR)/doc/cracklib/$$f ;\
	done

cracklib: uclibc $(TARGET_DIR)/$(CRACKLIB_TARGET_BINARY)

cracklib-clean:
	-rm -f $(TARGET_DIR)/$(CRACKLIB_TARGET_BINARY) \
		$(TARGET_DIR)/usr/lib/pw_dict*
	-rm -rf $(DOC_DIR)/doc/cracklib
	-$(MAKE) -C $(CRACKLIB_DIR) clean

cracklib-dirclean:
	rm -rf $(CRACKLIB_DIR)
endif

