/*
 * radv.c  --  Test program to have user-space application send out router
 *             advertisements every so often.
 *
 * Copyright 1995 by Dan McDonald, Ken Chin, and Bao Phan
 *	All Rights Reserved.  
 *      All Rights under this copyright have been assigned to NRL.
 */


#include <stdio.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <netinet6/in6.h>
#include <netinet6/in6_var.h>
#include <netinet6/ipv6.h>
#include <netinet6/ipv6_var.h>
#include <netinet6/ipv6_icmp.h>
#include <unistd.h>

struct ll_addr
{
  u_int8 type;
  u_int8 length;
  char addr[6];
};

void main(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  char buffer[512], ch;
  struct sockaddr_in6 dst;
  int s, hoplimit = 69, bits = 0, lifetime = 3600, reach = 10000, 
      retrans = 1000, count = ICMPV6_RADVMINLEN;
  struct ipv6_icmp *icmp;
  struct ext_mtu *mtu;
  struct ext_redir *redir;
  struct ext_prefinfo *prefix;
  struct ll_addr *t_addr;
  int mflag = 0, pflag = 0, rflag = 0, sflag = 0, tflag = 0, lflag = 0,
    iflag = 0;
  char *cur,abuf[80];
  struct inet6_ifreq ifr;
  
  s = socket(AF_INET6, SOCK_RAW, NEXTHDR_ICMPV6);
  if (s <0)
    {
      perror("socket");
      exit(1);
    }

  icmp = (struct ipv6_icmp *)buffer;
  icmp->icmp_type = ICMPV6_ROUTERADV;
  icmp->icmp_code = 0;
  icmp->icmp_cksum = 0;
  icmp->icmp_radvhop = hoplimit;
  icmp->icmp_radvbits = bits;
  icmp->icmp_radvlifetime = htons(lifetime);
  icmp->icmp_radvreach = htonl(reach);
  icmp->icmp_radvretrans = htonl(retrans);
  cur = (char *)icmp->icmp_radvext;

  /*
   * Parse command line options here if any.
   */
  while ((ch = getopt(argc,argv, "i:m:p:rstl")) !=EOF)
    switch(ch){
    case 'i':
      strncpy(ifr.ifr_name,optarg,IFNAMSIZ);
      iflag++;
      break;
    case 'l':
      lflag = 1;
      break;
    case 's':
      sflag = 1;
      break;
    case 't':
      tflag = 1;
      break;
    case 'p':
      pflag = 1;
      strncpy(abuf,optarg,80);
      break;
    case 'r':
      rflag = 1;
      break;
    case 'm':
      mtu = (struct ext_mtu *) cur;
      mtu->mtu_extid = 5;
      mtu->mtu_length = 1;
      mtu->mtu_reserved =0;
      mtu->mtu_mtu = htonl(atoi(optarg));
      count += sizeof(struct ext_mtu);
      mtu ++;
      cur = (char *)mtu;
      break;
    }
  argv +=optind;
  argc -=optind;

  /*source link layer*/
  if (tflag) {
    t_addr = (struct ll_addr *) cur;
    t_addr->type = 1;
    t_addr->length = 1;
    t_addr->addr[0] = 0;
    t_addr->addr[1] = 0x20;
    t_addr->addr[2] = 0xaf;
    t_addr->addr[3] = 0xc;
    t_addr->addr[4] = 0x5f;
    t_addr->addr[5] = 0x58;
    count += sizeof(struct ll_addr);
    t_addr ++;
    cur = (char *)t_addr;
  }

  /* prefix */
  if (pflag) {
    prefix = (struct ext_prefinfo *) cur;
    prefix->pre_extid = 3;
    prefix->pre_length = 4;
    prefix->pre_prefixsize = 80;
    prefix->pre_bits = 192;
    prefix->pre_valid = htonl(123456); /*pre_valid*/
    prefix->pre_preferred = htonl(12345);/*pre_preferred*/ /* pref<=valid */
    prefix->pre_reserved = 0;
    /*if (ascii2addr(AF_INET6, "5f00:3000:84fa:5a00::0", 
		 (void *)&(prefix->pre_prefix)) < 0) {
      printf("error ascii2addr\n");
      exit(1);
    }*/
    if (ascii2addr(AF_INET6, abuf,(void *)&(prefix->pre_prefix)) < 0) {
      printf("error ascii2addr\n");
      exit(1);
    }
    count += sizeof(struct ext_prefinfo);
    prefix ++;
    cur = (char *)prefix;
  }

  /* redirect*/
  if (rflag) {
    redir = (struct ext_redir *) cur;
    redir->rd_extid = 4;
    redir->rd_reserved[0] = 0;
    redir->rd_reserved[1] = 0;
    redir->rd_reserved[2] = 0;
    redir->rd_reserved[3] = 0;
    redir->rd_reserved[4] = 0;
    redir->rd_reserved[5] = 0;
    redir->rd_length = sizeof(struct ext_redir);
    count += sizeof(struct ext_redir);
    redir ++;
    cur = (char *)redir;
  }

  dst.sin6_family = AF_INET6;
  dst.sin6_len = sizeof(dst);
  dst.sin6_port = 0;
  dst.sin6_flowinfo = 0;
  /* May want to make this more specific so all nodes aren't tickled. */
  IN6_ADDR_ASSIGN(dst.sin6_addr,htonl(0xff020000),0,0,htonl(1));

  if (iflag)
    {
      printf("Sending out interface %s.\n",ifr.ifr_name);
      if (ioctl(s, SIOCGIFADDR_INET6, &ifr) == -1)
	perror("SIOCGIFADDR_INET6");
      else
	if (setsockopt(s, IPPROTO_IP,IPV6_MULTICAST_IF,
		       (char *)&ifr.ifr_addr.sin6_addr, 
		       sizeof(struct in_addr6)) == -1)
	  perror("setsockopt IPV6_MULTICAST_IF");
    }

  /* Set multicast TTL to 255 for r. advert. */
  {
    u_char ttl = 255;
    if (setsockopt(s, IPPROTO_IP, IPV6_MULTICAST_TTL, &ttl, 1) == -1)
      perror("setsockopt IPV6_MULTICAST_TTL");
  }
  sendto(s, buffer, count, 0, (struct sockaddr *)&dst, dst.sin6_len);

  if (lflag)
    {
      printf("Go into 'listen to solicit' mode.\n");
    }
}
