#ifndef READ_QUERY_COMMAND
#define READ_QUERY_COMMAND

/***************************************
  $Revision: 1.26 $

  Query command module (qc)

  Status: NOT REVUED, TESTED

  ******************/ /******************
  Copyright (c) 1999,2000,2001,2002               RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/
#define USAGE  "% Usage: whois [-aFKlLmMrRx] [-s sources] [-T type(s)] [-i attr] keys\n" \
"% whois {-t|-v} type\n"\
"% whois -q {version|sources}\n"\
"% \n"\
"% Where:\n"\
"% \n"\
"% -k                         open/close session (persistent connection)\n"\
"% -r                         turn off recursive lookups\n"\
"% -F                         fast raw output (implies -r)\n"\
"% -K                         print only primary keys (implies -r)\n"\
"% -R                         show local copy of the domain object (no referral)\n"\
"% -a                         search all databases\n"\
"% -s source[[,source] ... ]  search only databases with source 'source'\n"\
"% -T type[[,type] ... ]      only look for objects of type 'type'\n"\
"% -i [attr][[,attr] ... ]    do an inverse lookup for specified attributes\n"\
"% -d                         include reverse domains for look-up by IP\n"\
"% -l                         find first level Less specific matches\n"\
"% -L                         find all Less specific matches\n"\
"% -m                         find first level more specific matches\n"\
"% -M                         find all More specific matches\n"\
"% -x                         find exact matches only\n"\
"% -t type                    requests template for object of type 'type'\n"\
"% -v type                    requests verbose template for object of type 'type'\n"\
"% \n"\
"% Please note that most of these flags are NOT understood by\n"\
"% non RIPE whois servers\n\n"
                       /* ^^^  output must end with this blank line */

#include <glib.h>
#include "bitmask.h"
#include "sk.h"


typedef enum {
  QC_EMPTY,
  QC_PARERR,
  QC_SYNERR,
  QC_NOKEY,
  QC_TEMPLATE,
  QC_HELP,
  QC_REAL,
  QC_FILTERED,

  QC_TYPE_MAX
} qc_qtype_t;
/* now this must be sync'ed with that: */
#ifdef QC_IMPL
char *qrytype_str[] = {
  "EMPTY",
  "PARAMETER ERROR",
  "SYNTAX ERROR",
  "NO KEY",
  "TEMPLATE",
  "HELP",
  "REAL",
  "FILTERED"
};
#endif


/* types of -q queries */
#define QC_Q_SOURCES 0
#define QC_Q_VERSION 1



typedef struct Query_environ_t {
  sk_conn_st   condat;
  unsigned int k;
  GList *sources_list;
  char *version;
  ip_addr_t pIP; /* passed IP */
} Query_environ;

typedef struct Query_command_t {
  qc_qtype_t   query_type;

  /* -c: query for the most specific inetnum/inet6num with the "mnt-irt:" 
         attribute set */
  gboolean c_irt_search;

  int d;
  int e;
  int fast;
  int g;
  mask_t inv_attrs_bitmap;
  int recursive;
  int l;
  int m;
  int q;
  int t;
  int v;
  int x;
  int filtered;
  int L;
  int M;
  int R;
  int S;
  mask_t object_type_bitmap;
  mask_t keytypes_bitmap;
  char *keys;
} Query_command;

char *QC_bitmap_to_string(mask_t bitmap);
char *QC_environ_to_string(Query_environ qe);
char *QC_query_command_to_string(Query_command *query_command);
void QC_environ_free(Query_environ *qe);
void QC_free(Query_command *qc);
Query_command *QC_create(char *query_str, Query_environ *qe);
Query_environ *QC_environ_new(char *ip, int sock);
Query_environ *QC_environ_update(Query_command *qc, Query_environ *qe);
char *QC_get_qrytype(qc_qtype_t qrytype);
#endif /* READ_QUERY_COMMAND */
