# dbupdate.pl
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: dbupdate.pl,v 2.5 1997/10/17 11:08:28 chris Exp $
#
#	$RCSfile: dbupdate.pl,v $
#	$Revision: 2.5 $
#	$Author: chris $
#	$Date: 1997/10/17 11:08:28 $

#
# This is a client that will update objects read from a file directly
# in the database.
# It will update the object in the database that is linked to the
# source field of the object, so better make sure you have a source field
# and that it has a database associated to it ...


@INC = ("LIBDIR", @INC);

require "getopts.pl";

require "rconf.pl";

require "misc.pl";
require "processdata.pl";

# Parse options:
#
#
# -v			- verbose output (LONGACK)
# -m mail-address       - treat as mail from mail address for
#                         the MAIL-FROM authorization
# -M			- treat input file (or STDIN) as mail and compose
#			  and send ack mail back
# -A                    - assume "assign" mode, only add will be allowed
#                         usually set by parsing mail headers
# -T                    - TEST database update, accept creation of maintainers
#                         always, but give a warning that this is not the
#                         case in the normal database

&Getopts('Am:MTvV');

#
# Need this below for running perl in tainted mode.

$ENV{"PATH"} = "";
$ENV{"SHELL"} = "/bin/sh";
$ENV{"IFS"} = "";

#
# Read config file from RIPEDBCNF, or set to default.

$conffile=$ENV{"RIPEDBCNF"};
$conffile= $RIPEConfig{DEFCONFIG} unless $conffile;
print STDERR "dbupdate - reading config\n" if $opt_V;
&rconf($conffile);

#
# run on low priority, whois server queries have an
# higher priority

lower_priority;

if ($opt_m) {
   $opt_M=1;
   $FROM=$opt_m;
   $REPLYTO=$FROM;
   print STDERR "Treating as mail from $FROM\n" if ($opt_V);
}

&dbupdate("", STDOUT);

# end of program
