# read_objs.pl
#
# Copyright (c) 1993, 1994, 1995, 1996, 1997  The TERENA Association
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# $Id: read_objs.pl,v 2.2 1997/10/02 15:26:03 chris Exp $
#
# This is a sub-routine to read the contents of 
# an objects description file into a set of arrays.


sub read_objs {

local($objs_descs) = @_;

open(OBJ_DES, $objs_descs) || &fatalerror("read_objs: Cannot open file \"$objs_descs\", $!");

while (<OBJ_DES>) {

	next if (/^\#/);	# ignore comments
	next if (/^\s*$/);	# ignore blank lines

	last if (/^ENDOBJ/);	# stop when "ENDATB" reached

	if (/^\s*OBJ\b/)	{

	# look at current line entry

	$entry = $_;
	# print("\nEntry is $entry\n");

	# remove OBJ from the line

	$entry =~ s/^\s*OBJ\b\s+//;
	$entry =~s/\s+/ /g;	# replace > 1 blanks with 1 blank
	$entry =~s/ $//;

	# print("\nEntry is $entry\n");

	# divide $entry into $fields using spaces as delimiter
	# we need to keep the third part altogether :-)

	($object, $field, $text) = split(/\s/, $entry, 3); 

	if ( $field eq "DESC")	{

        	if ($obj_descs{$object})	{

			$obj_descs{$object} = join ("\n", $obj_descs{$object}, $text);
	}
		else	{
		$obj_descs{$object} = $text;
		}
	}

# Is this doing what you expect
 # print("\nObject is $object");
 # print("\nDescription is $obj_descs{$object}\n");

	} # End of if statement

   } # End of while loop

close(OBJ_DES);

# Test that it worked

 # print ("\nLine 72\n");
 
 while ( ($object, $description) = each (%obj_descs) ) {
 
 	# print("\n$object\n$description\n");
 
 
 	} # End of while loop

	
} # End of sub read_objs

# Return the value of 1

1;




