#       encmp - compare two associative arrays
#
#	$RCSfile: encmp.pl,v $
#	$Revision: 0.14 $
#	$Author: ripe-dbm $
#	$Date: 1995/11/17 14:43:00 $
#
#	This routine takes two objects and compares them case insensitive
#	Returns 1 if objects are equal, else returns 0;
#
#       Arguments:
#	*this, *that		two pointers to assoc arrays

sub encmp {

    local(*this, *that) = @_;
    local(%a) = %this;
    local(%b) = %that;

    local($atype) = &entype(*a);
    local($btype) = &entype(*b);

    return 0 if $atype ne $btype;

    foreach (split(/\s+/, $OBJATSQ{$atype})) {
	$a{$_} =~ tr/A-Z/a-z/;
	$b{$_} =~ tr/A-Z/a-z/;
	
	print STDERR "-$a{$_}-\n" if $opt_V;
	print STDERR "-$b{$_}-\n" if $opt_V;
	
	return 0 if $a{$_} ne $b{$_};
    }
    return 1;
}

1;
