#
#       addkey - add, delete keys
#
#	$RCSfile: addkey.pl,v $
#	$Revision: 0.16 $
#	$Author: marten $
#	$Date: 1994/09/20 11:24:35 $

sub addkey {

    local(*db, $key, $offset) = @_;
    local($TOOMANY) = -1;
    
    local($dbkey) = $db{$key};
    if (!$dbkey) {
	$db{$key} =  $offset;
	return;
    }
    
    return if $dbkey == $TOOMANY;
    
    local(@count) = split(/\,/, $dbkey);
    if ($#count >= $MAXHITS) {
	$db{$key} = $TOOMANY;
	return;
    }
    $db{$key} .= ",$offset" if $dbkey;
}

sub delkey {

    local(*db, $key, $offset) = @_;

    if ($db{$key} =~ /^$offset$/) {delete $db{$key};}
    elsif ($db{$key} =~ s/^$offset,//) {}
    elsif ($db{$key} =~ s/,$offset,/,/) {}
    elsif ($db{$key} =~ s/,$offset$//) {}
}

1;
