/***************************************
  $Revision: 1.11 $

  mm - MIME Parser module. Functions to parse a mail message,
  find if it is MIME-encapsulated, and return the parts of
  the message which are supported by the UP module.

  Status: NOT COMPLETE, NOT REVUED, NOT TESTED 

  Design and implementation by: Daniele Arena

  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/


/* Included headers: */

/* These come from c-client */
#include "mail.h"
#include "osdep.h"
#include "misc.h"
/*#include "rfc822.h"*/
/*#include "smtp.h"*/
/*#include "nntp.h"*/



/* String sizes */
#define STR_S   63
#define STR_M   255
#define STR_L   1023
#define STR_XL  4095
#define STR_XXL 16383


/* Local #defines */

#define NO_DEBUG 0
#define DO_DEBUG 1
#define DEFAULT_DEBUG DO_DEBUG
#define TEMPDIR "/tmp"
#define FILENAMELEN STR_L
#define GLOBALPREFIX "mime"


/* Structure definition */

typedef struct MM_body_section *sectptr;

typedef struct MM_body_section {
  char *number;
  char *type;
  unsigned long size;
  char *mime_headers;
  char *contents;
  short supported;
  sectptr next;
} MM_b_section;

typedef struct MM_body_section_list {
  int size;
  MM_b_section *head;
  MM_b_section *tail;
} MM_bs_list;


typedef struct MM_extracted_mimepart *partptr;

typedef struct MM_extracted_mimepart {
  char *number;
  char *type;
  char *file;
  short supported;
  partptr next;
} MM_xmp;

typedef struct MM_extracted_mimepart_list {
  int size;
  MM_xmp *head;
  MM_xmp *tail;
} MM_xmp_list;


typedef struct MM_mail_header {
  char *from;
  char *subject;
  char *date;
  char *message_id;
  char *reply_to;
  char *cc;
} MM_header;


/* Needed for dbupdate, written in C++ */

#ifdef __cplusplus
extern "C" {
#endif


/* Function definition */

/* API functions */
int MM_decode (char *mail_file, MM_header *mail_header, MM_xmp_list *part_list, long mesgno, long debug);
int MM_store (char *source_file, char *destination_file, long debug);
void MM_cleanup (MM_xmp_list *part_list, long debug);

/* Internal support functions */
int mm (MAILSTREAM *stream, MM_header *hdr, MM_xmp_list *part_list, long mesgno, long debug);
void get_body_info (BODY *body,char *pfx,long i, MM_bs_list *sect_list, long debug);
void status (MAILSTREAM *stream);
void MM_bs_list_init (MM_bs_list *section_list);
void MM_bs_list_ins_last (MM_bs_list *section_list, MM_b_section *newsection);
void MM_bs_list_cleanup (MM_bs_list *section_list, long debug);
void MM_xmp_list_init (MM_xmp_list *part_list);
void MM_xmp_list_ins_last (MM_xmp_list *part_list, MM_xmp *newpart);
char *get_header_line (MAILSTREAM *stream, long mesgno, STRINGLIST *cur, char *hdr_title);
void write_file (char *filename, char *text, size_t text_size);
void read_file (char *filename);
void put_in_file (char *fileprefix, char *extension, char *text, size_t text_size);
int do_regex_test(const char *pattern, char *string);


/* Needed for dbupdate, written in C++ */

#ifdef __cplusplus
}
#endif


