/***************************************
  $Revision: 1.5 $

  Whois query (wh) - connects to a whois server and returns result

  Status: NOT REVIEWED, TESTED
  
  Design and implementation by: Marek Bukowy
  
  Note:  still not final. Probably SK calls should be moved to the
         calling routine
  
  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>

#include <erroutines.h>
#include "socket.h"

int
WH_sock(int sock, char *hostname, int port, 
	char *query, int maxlines, int timeout)
{
  
  FILE *sfi;
  FILE *sfo;
  struct sockaddr_in sin;
  struct hostent *hp;
  int ch;
  int s;
  
#if 0
  char log_str[256];
  sprintf(log_str, "would perform query >%s< to %s:%d  \n"
	  "limits: line %d tmout %d and print on socket %d\n",
	  query,hostname,port, maxlines,timeout,sock );
  log_inst_print(log_str);
#endif
  
  if ( (hp = gethostbyname(hostname)) == NULL) {
    return WH_BADHOST;
  }

  s = socket(AF_INET, SOCK_STREAM, 0);
  if (s < 0) {
    return WH_SOCKET;
  }
  
  bzero((caddr_t)&sin, sizeof (sin));
  sin.sin_family = hp->h_addrtype;
  if (bind(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
    close(s);
    return WH_BIND;
  }
  bcopy(hp->h_addr, (char *)&sin.sin_addr, hp->h_length);
  sin.sin_port=htons(port);

  if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
    close(s);
    return WH_CONNECT;
  }

  /*  SK_puts(sock, "% Connection established...\n"); */
  
#if 0
  sfi = fdopen(s, "r");
  sfo = fdopen(s, "w");
  if (sfi == NULL || sfo == NULL) {
    (void)close(s);
    return WH_OPEN;
  }

  fprintf(sfo, "%s\r\n", query);
  fflush(sfo);

  while ((ch = getc(sfi)) != EOF) {
    SK_putc(sock,ch);
  }

  fclose(sfo);
  fclose(sfi);
#else
  SK_puts(s, query);
  SK_puts(s, "\r\n");

  while( (ch = SK_getc(s)) != EOF ) {
    SK_putc(sock,ch);
  }
#endif
  close(s);
}

