/* exit.c - quit, error */


#include <sys/ioctl.h>
#include <signal.h>
#include <setjmp.h>
#include "define.h"
static struct  sgttyb  save_cttymode;	/* place to save ctty mode */

quit()
{
  char buf[100];

  printf("\r\nQuit handler: ");
  /* A.boardnum<0 means no real board in use yet (tho >=0 does not
     guarantee it is there yet, could be explicity requested) */
  if (A.boardnum>=0 && ck_mecb_output(mecbfd))
    return;			/* from ^C or explicit quit call */
  if (pid>0)
    kill(pid,9);
  set_orig_ctty();		/* put orig status back */
  printf("found none.\n");
  printf("Leaving board #%d\n",A.boardnum);
  fflush(stdout);
  fflush(stderr);
  exit(0);
}
/* returns 0 if no output, linemon inactivated by SIGEMT signal */
/*         1 if output detected, linemon reactivated, ready to go on */
ck_mecb_output(mecbfd)
int mecbfd;
{
  ioctl(mecbfd,TIOCFLUSH,NULL); /* drop any old chars in queues */
  if (pid>0)
    kill(pid,SIGEMT);		/* stop linemon at least for a while */
  printf("Checking for output from board...");
  if (TOgetc(mecbfd,1 /*sec timeout*/)>=0)
    {
      printf("found some.\r\n");
      printf("\007\007Please reset (~r) or otherwise stop output, then quit again--thanks.\r\n");
      sleep(1);
      if (pid>0)
	kill(pid,SIGEMT);	/* resume linemon */
      return 1;			/* found output */
    }
  return 0;			/* no output */
}
sigsusp()
{
  printf("Suspend handler: ");
  if (A.boardnum >= 0 && ck_mecb_output(mecbfd))
    return;			/* let user clean up */
  printf("found none.\r\n");
  save_ctty(&save_cttymode);	/* save current status in our area */
  set_orig_ctty();
  printf("Suspending %ctip, board #%d--please return to it (fg command) as soon as possible\n",(A.xdev?'M':'m'),A.boardnum);
  fflush(stdout);
  fflush(stderr);
  signal(SIGTSTP, SIG_DFL);
  kill(getpid(), SIGTSTP);	/* let shell handle */
}

static int dead = 0;		/* for comm between sighup and sigcont */

sigcont()
{
  if (dead)			/* hangup int'd by sigcont */
    sighup();			/* go do it anyway */
  signal(SIGCONT, sigcont);
  signal(SIGTSTP, sigsusp);	/* go back to us handling it */
  if (pid>0)
    kill(pid,SIGEMT);	/* resume linemon */
  printf("Continuing %ctip on board %d\n",(A.xdev?'M':'m'),A.boardnum);
  restore_ctty(&save_cttymode); /* from copy saved on way out */
}

/* here on hangup signal--friendly kill or dropped line */
/* if was ^Z'd, this will be interrupted by sigcont signal, */
/* (when the kernel does the kill syscall, it cks int's) */
/*  so mark that state immediately-- */
/* (doing signal(SIGCONT, SIG_IGN) immediately is not effective--
   apparently the kernel cks for int's at the start of the syscall) */

sighup()
{
  dead = 1;			/* in case interrupted by sigcont */
				/* happens with kill 1 of ^Z'd job */
  if (pid>0)
    kill(pid,9);		/* kill linemon */
  pid = 0;
  reset_mecb(A.boardnum);	/* lost user, so do it quietly */
  exit(1);
}
/*
 * sigalrm -- terminate if keyboard idle 10 minutes
 * Not in use
 */
sigalrm()
{
	if (idle++ >= 120) {
	    fprintf(stderr,"\nKeyboard idle 10 mins.  %s released.\n",
		mecbdevs[A.boardnum]);
	    quit();
	}
	signal(SIGALRM, sigalrm);
	alarm(60);
}


/*------------------------------------------------------------------------------
 *  error  --  print message to stderr and quit
 *------------------------------------------------------------------------------
 */
error(str1, str2)
	char	*str1, *str2;
{
	fprintf(stderr, str1, str2);
	quit();
}

/* set up to catch interrupt, hangup, stop , continue-- */
arm_signals()
{
  signal(SIGINT,  quit);
  signal(SIGTSTP, sigsusp); 
  signal(SIGCONT, sigcont); 
  signal(SIGHUP, sighup);
  signal(SIGTERM, sighup);	/* same as hup--polite kill */
}
/* set all 5 signals back to system default, that is, kill proces
   on INT, HUP, or TERM, stop on TSTP, continue on CONT */
set_default_signals()
{
  signal(SIGINT, SIG_DFL);
  signal(SIGHUP, SIG_DFL);
  signal(SIGTSTP, SIG_DFL);
  signal(SIGCONT, SIG_DFL);
  signal(SIGTERM, SIG_DFL);
}
